#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer import ITEM_TYPE
from shinkensolutions.api.synchronizer.source.item.source_item import SourceItem


class SourceCommand(SourceItem):
    __slots__ = SourceItem.__slots__ + [
        'uuid',
        'definition_order',
        'command_line',
        'warning_threshold_cpu_usage',
        'poller_tag',
        'reactionner_tag',
        'module_type',
        'timeout',
        'shell_execution',
        'enable_environment_macros',
        'imported_from',
        'command_name'
    ]
    
    
    def __init__(self):
        super(SourceCommand, self).__init__()
        self.item_type = ITEM_TYPE.COMMANDS
