SHINKEN.TOOLS.TEST_AUTO_PAGINATION = (function ( self ) {
    self.DOM    = {};
    self.ACTION = {};
    self.TEST   = {};
    self.CONST  = {
        STATE_PAGINATION: {
            ORIGIN: "FIRST",
            MIDDLE: "PREVIOUS_NEXT",
            LAST  : "LAST"
        }
    };
    //********************************************  DOM **************************************************//
    
    self.DOM.paginationComponant           = function ( dom_element_parent ) {
        return dom_element_parent.querySelector( ".shinken-pagination-container" );
    };
    self.DOM.paginationSelector            = function ( dom_element_parent ) {
        return dom_element_parent.querySelectorAll( ".shinken-option" );
    };
    self.DOM.selectPage                    = function ( dom_element_parent ) {
        return dom_element_parent.querySelectorAll( ".shinken-option" );
    };
    //********************************************  ACTION **************************************************//
    self.ACTION.changePaginationSettings   = function ( timeout, page_size, total_size ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.changePaginationSettings', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            CONTROLLER.Apply.set_apply_msg.pagination.setPageSize( page_size );
            CONTROLLER.Apply.set_apply_msg.pagination.setTotalElement( total_size || CONTROLLER.Apply.set_apply_msg.pagination.total_page );
            CONTROLLER.Apply.set_apply_msg.pagination.hasPageTotal = Math.ceil( total_size / page_size );
            CONTROLLER.Apply.set_apply_msg.lines.computeHtml( CONTROLLER.Apply.set_apply_msg.pagination );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.paginationSelectPageNumber = function ( timeout, dom_element ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.paginationSelectPageNumber', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _selector           = self.DOM.paginationSelector( dom_element );
            var _paginationSelector = self.DOM.selectPage( dom_element );
            SHINKEN.TOOLS.TEST_AUTO_APPLY.ACTION.clickOnPaginationSelectButton( 500 );
            SHINKEN.TOOLS.TEST_AUTO_DOM.mouseup( 1000, _paginationSelector[ _paginationSelector.length - 1 ], true );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isText( 1250, SHINKEN.TOOLS.TEST_AUTO_APPLY.DOM.getPaginationSelectorLabel(), _paginationSelector.length, "is text " + _paginationSelector.length - 1 );
            SHINKEN.TOOLS.TEST_AUTO_DOM.mouseup( 1400, _paginationSelector[ 0 ], true, 0 );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    self.ACTION.paginationSelectPageNumberExist = function ( timeout, dom_element ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.paginationSelectPageNumberExist', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _paginationSelector = self.DOM.paginationSelector( dom_element );
            SHINKEN.TOOLS.TEST_AUTO_APPLY.ACTION.clickOnPaginationSelectButton( 500 );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 750, _paginationSelector[ _paginationSelector.length - 1 ], "selector " );
            SHINKEN.TOOLS.TEST_AUTO_APPLY.ACTION.clickOnPaginationSelectButton( 1000 );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.paginationUseArrows             = function ( timeout, dom_element, state ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.paginationUseArrows', state );
        setTimeout( function () {
            var _arrows             = SHINKEN.TOOLS.TEST_AUTO_APPLY.DOM.getPaginationSelectorArrows();
            var _paginationSelector = self.DOM.selectPage( dom_element );
            switch ( state ) {
                case self.CONST.STATE_PAGINATION.FIRST:
                    var _timeout = 0;
                    SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isText( 500, SHINKEN.TOOLS.TEST_AUTO_APPLY.DOM.getPaginationSelectorLabel(), SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.FIRST + 1, "Contain text 1" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 555, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.FIRST ], "pointer-events", "none", "selector option first" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 560, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.PREVIOUS ], "pointer-events", "none", "selector option first" );
                    SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
                    break;
                case self.CONST.STATE_PAGINATION.LAST:
                    SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.click( 1000, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.LAST ], false, 0 );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isText( 1100, SHINKEN.TOOLS.TEST_AUTO_APPLY.DOM.getPaginationSelectorLabel(), _paginationSelector.length, "Contain text " + _paginationSelector );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 1100, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.LAST ], "pointer-events", "none", "selector option last" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 1100, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.NEXT ], "pointer-events", "none", "selector option last" );
                    SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
                    break;
                case self.CONST.STATE_PAGINATION.PREVIOUS_NEXT:
                    SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.click( 250, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.NEXT ], false, 0 );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNotStyle( 550, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.FIRST ], "pointer-events", "none", "selector option middle" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNotStyle( 551, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.PREVIOUS ], "pointer-events", "none", "selector option middle" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNotStyle( 552, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.NEXT ], "pointer-events", "none", "selector option middle" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNotStyle( 553, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.LAST ], "pointer-events", "none", "selector option middle" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.click( 250, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.NEXT ], false, 0 );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.click( 250, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.PREVIOUS ], false, 0 );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNotStyle( 550, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.FIRST ], "pointer-events", "none", "selector option middle" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNotStyle( 551, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.PREVIOUS ], "pointer-events", "none", "selector option middle" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNotStyle( 552, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.NEXT ], "pointer-events", "none", "selector option middle" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNotStyle( 553, _arrows[ SHINKEN.TOOLS.TEST_AUTO_APPLY.CONST.NAVIGATION_ARROWS.LAST ], "pointer-events", "none", "selector option middle" );
                    SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
                    
                    break;
            }
        }, timeout );
        return _to_return;
    };
    
    self.ACTION.moveCentralSlider = function ( timeout ) {
        var _to_return = 6100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.moveCentralSlider', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 1250, SHINKEN.TOOLS.TEST_AUTO_APPLY.DOM.getLeftColumn(), "width", 200 );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 1500, SHINKEN.TOOLS.TEST_AUTO_APPLY.DOM.getGrowLeftPanelButton() );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 1750, SHINKEN.TOOLS.TEST_AUTO_APPLY.DOM.getLeftColumn(), "width", 800 );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 2000, SHINKEN.TOOLS.TEST_AUTO_APPLY.DOM.getShrinkLeftPanelButton() );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 2250, SHINKEN.TOOLS.TEST_AUTO_APPLY.DOM.getLeftColumn(), "width", 200 );
            SHINKEN.TOOLS.TEST_AUTO_APPLY.ACTION.askVerifyApply( 2500 );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 6000, SHINKEN.TOOLS.TEST_AUTO_APPLY.DOM.getLeftColumn(), "width", 450 );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  TEST **************************************************//
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_PAGINATION || {} );