SHINKEN.TOOLS.TEST_AUTO_SOURCE = (function ( self ) {
    self.DOM                                  = {};
    self.TEST                                 = {};
    self.ACTION                               = {};
    self.CONST                                = {};
    //********************************************  DOM   **************************************************//
    self.DOM.tabNavigation                    = function ( tab_name, window ) {
        var _document = window ? window.document : document;
        return _document.querySelector( '.shinken-window-element[data-name="' + tab_name + '"]' );
    };
    self.DOM.buttonImport                     = function () {
        return document.querySelector( '.shinken-play-import-source' );
    };
    self.DOM.getDomWrapper                    = function () {
        return document.getElementById( 'wrapper' );
    };
    self.DOM.getWindowGroupDom                = function () {
        return document.querySelector( ".shinken-source-navigation-container .shinken-window-group" );
    };
    self.DOM.getWindowsDom                    = function () {
        return self.DOM.getWindowGroupDom().querySelectorAll( ".shinken-window-element" );
    };
    self.DOM.getForceImportButton             = function () {
        return document.querySelector( ".shinken-play-import-source" );
    };
    self.DOM.getSourceName                    = function () {
        return self.DOM.getDomWrapper().dataset[ 'sourceName' ];
    };
    //********************************************  TEST   **************************************************//
    self.TEST.numberTabs                      = function ( timeout, nb_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.getWindowsDom(), nb_expected, "nb windows element" );
        }, timeout );
        return 100;
    };
    self.TEST.configurationFormHeader         = function ( timeout ) {
        setTimeout( function () {
            var _dom_header = document.querySelector( '#id-shinken-source-configuration-container .shinken-header-row' );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( timeout, _dom_header );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _dom_header, "backgroundColor", "rgba(30, 30, 30, 0.8)", "Source configuration header" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _dom_header, "height", "37px", "Source configuration header" );
        }, timeout );
        return 200;
    };
    self.TEST.forceImportButtonStatus         = function ( timeout, state_expected ) {
        setTimeout( function () {
            var _dom = self.DOM.getForceImportButton();
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom, "Button force import" );
            switch ( state_expected ) {
                case COMPONENT.CONST.BTN_STATE.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "0.5" );
                    break;
                case COMPONENT.CONST.BTN_STATE.ON:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "1" );
                    break;
            }
        }, timeout );
        return 100;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.switchSourceActivity          = function ( timeout, source_name, only_if_inactive ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'switchSourceActivity', 'only_if_inactive = ' + only_if_inactive );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _source = MANAGER.__instance_source_distributor.findSource( source_name );
            if ( only_if_inactive && _source.isActive() ) {
            }
            else {
                _source.toggleEnable();
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.forceImport                   = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getForceImportButton() );
        }, timeout );
        return 100;
    };
    self.ACTION.navigateInTab                 = function ( timeout, tab_name, window ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.navigateInTab', tab_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.tabNavigation( tab_name, window ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.importSource                  = function ( timeout ) {
        var _to_return = 10000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.import' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonImport() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.deleteIpRangeByRequest        = function ( timeout, code_expected, is_current, switch_case_value ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'deleteIpRange', switch_case_value );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK", _to_return );
                return;
            }
            self.__delete_external_object( code_expected, is_current, '', switch_case_value );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.__delete_external_object             = function ( code_expected, is_current, extra_label, switch_case_value ) {
        var _url  = self.__delete_external_object_url( switch_case_value );
        var _data = self.__delete_external_object_data( is_current, switch_case_value );
        self.__do__external_object_delete_request( _url, _data, code_expected, extra_label );
    };
    self.__delete_external_object_data        = function ( is_current, switch_value ) {
        if ( is_current ) {
            return getCurrentObjectFromProperty();
        }
        var _to_return = {};
        if ( !switch_value ) {
            switch_value = __shinken_test_type + "-" + __phase;
            if ( __shinken_test_type === 'DEV' ) {
                switch_value = "DEV";
            }
        }
        switch ( switch_value ) {
            case "00204-1":
                var _dom_element = SHINKEN.TOOLS.TEST_AUTO_SOURCE_ANALYZER.DOM.ipRangeLineByName( "test_auto_204" );
                if ( _dom_element ) {
                    _to_return[ "_id" ] = _dom_element.getAttribute( "data-id" );
                }
                break;
            
        }
        return _to_return;
    };
    self.__delete_external_object_url         = function ( switch_case_value ) {
        var _switch_value = switch_case_value || __shinken_test_type + "-" + __phase;
        if ( __shinken_test_type === 'DEV' ) {
            _switch_value = "DEV";
        }
        switch ( _switch_value ) {
            case "00204-1":
                return '/sources/server-analyzer/discovery/delete/';
            
        }
        
    };
    self.__do__external_object_delete_request = function ( url, data, code_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        
        if ( !url ) {
            return;
        }
        $.post( url, data ).success(
            function ( data ) {
                if ( typeof code_expected !== "object" ) {
                    code_expected = [code_expected];
                }
                if ( !SHINKEN.TOOLS.ARRAY.contains( code_expected, data.rc ) ) {
                    //SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " La suppression de l'élement n'a pas réussi [SUCCESS]" + JSON.stringify( data ) );
                }
            }
        ).error(
            function ( res ) {
                //SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " La suppression de l'élement n'a pas réussi [ERROR]" + res.responseText );
            }
        );
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_SOURCE || {} );
