SHINKEN.TOOLS.TEST_AUTO_UI_VISU_MENU = (function ( self ) {
    self.DOM                                         = {};
    self.TEST                                        = {};
    self.TEST.WIDGET                                 = {};
    self.TEST.JS                                     = {};
    self.ACTION                                      = {};
    self.CONST                                       = {
        STATE_DISPLAY: {
            HIDDEN              : 0,
            VISIBLE             : 1,
            VISIBLE_AND_COLLAPSE: 2
        }
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getMenu                                 = function ( navigator ) {
        var _document = navigator ? navigator.document : document;
        return _document.querySelector( ".shinken-main-nav-bar-table" );
    };
    self.DOM.getUserConfigurationButton              = function () {
        return self.DOM.getMenu().querySelector( "#id-shinken-logout-button" );
    };
    self.DOM.getAddToFavoriteButton              = function () {
        return self.DOM.getMenu().querySelector( "#id-shinken-add-favorite" );
    };
    self.DOM.getLoginButtonLabel                     = function () {
        return self.DOM.getUserConfigurationButton().querySelector( ".shinken-user-name" );
    };
    self.DOM.getPopupConfigurationUser               = function ( navigator ) {
        var _document = navigator ? navigator.document : document;
        return _document.querySelector( ".shinken-dropdown-container-user-configuration" );
    };
    self.DOM.getDisconnectButton                     = function ( navigator ) {
        return self.DOM.getPopupConfigurationUser( navigator ).querySelector( "#id-shinken-user-disconnect-button" );
    };
    self.DOM.userConfigurationRadioListPropertyBlink = function ( navigator ) {
        return self.DOM.getPopupConfigurationUser( navigator ).querySelector( ".shinken-tbody-for-blink" );
    };
    self.DOM.userConfigurationRangePropertyVolume    = function ( navigator ) {
        return self.DOM.getPopupConfigurationUser( navigator ).querySelector( ".shinken-tbody-for-volume" );
    };
    self.DOM.userConfigurationRadioButtonByName      = function ( navigator, property_name, value ) {
        switch ( property_name ) {
            case "blink":
                return self.DOM.userConfigurationRadioListPropertyBlink( navigator ).querySelector( ".shinken-radio-element[data-name='radio-element-notification-blink'][data-value='" + value + "']" );
            case "volume":
                return self.DOM.userConfigurationRadioListPropertyBlink( navigator ).querySelector( ".shinken-radio-element[data-name='radio-element-notification-sound'][data-value='']" );
        }
    };
    self.DOM.userConfigurationRangeVolume            = function ( navigator ) {
        return self.DOM.userConfigurationRangePropertyVolume( navigator ).querySelector( ".shinken-notification-slider-sound" );
    };
    self.DOM.getNavigationMenuCell                   = function ( menu_name, navigator ) {
        var _selector = "";
        switch ( menu_name ) {
            case SHINKEN.SCREEN.TYPE.HIVE:
                _selector = ".shinken-portal-menu-cell";
                break;
            case SHINKEN.SCREEN.TYPE.LIST:
                _selector = ".shinken-list-menu-cell";
                break;
            case SHINKEN.SCREEN.TYPE.EVENT:
                _selector = ".shinken-event-menu-cell";
                break;
            case SHINKEN.SCREEN.TYPE.SERVICE_WEATHER:
                _selector = ".shinken-weather-menu-cell";
                break;
            case "shinken-extra-menu-cell":
                _selector = ".shinken-extra-menu-cell";
                break;
            case "shinken-collapsed-menu-cell":
                _selector = ".shinken-collapsed-menu-cell";
                break;
        }
        return self.DOM.getMenu( navigator ).querySelector( _selector );
    };
    self.DOM.getNavigationMenu                       = function ( menu_name, navigator ) {
        return self.DOM.getNavigationMenuCell( menu_name, navigator ).querySelector( ".dropdown-toggle" );
    };
    self.DOM.getNavigationSubMenu                    = function ( menu_name, sub_menu_name, navigator ) {
        return self.DOM.getNavigationMenuCell( menu_name, navigator ).querySelector( '.shinken-link[data-name="' + sub_menu_name + '"]' );
    };
    self.DOM.getNavigationCounters                   = function ( menu_name ) {
        var _doms      = self.DOM.getNavigationMenu( menu_name ).querySelectorAll( ".shinken-counter" );
        var _to_return = {};
        for ( var i = 0, _size_i = _doms.length; i < _size_i; i++ ) {
            if ( _doms[ i ].classList.contains( "shinken-error-counter" ) ) {
                _to_return[ "shinken-error-counter" ] = _doms[ i ];
            }
            else {
                _to_return[ "to_complete" ] = _doms[ i ];
            }
        }
        return _to_return;
    };
    self.DOM.logoCell                                = function () {
        return self.DOM.getMenu().querySelector( ".shinken-logo-cell" );
    };
    self.DOM.logoVersion                             = function () {
        return self.DOM.logoCell().querySelector( ".shinken-version-number" );
    };
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.userNameLabel                       = function ( timeout, value_expected ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.userNameLabel', value_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.getLoginButtonLabel(), value_expected, 'userNameLabel' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.activeView                          = function ( timeout, value_expected, navigator ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.activeView', value_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _controller = navigator ? navigator.CONTROLLER.UiVisualisation : CONTROLLER.UiVisualisation;
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _controller.active_view, value_expected, 'activeView' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.displayState                        = function ( timeout, state, navigator ) {
        var _to_return = 600;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.displayState', state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.getMenu( navigator );
            switch ( state ) {
                case self.CONST.STATE_DISPLAY.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 250, _dom );
                    SHINKEN.TOOLS.TEST_AUTO.__hasClass( _dom, 'shinken-navbar-collapsed-menu-activated', "menu", undefined, true );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 250, self.DOM.getNavigationMenuCell( "shinken-collapsed-menu-cell", navigator ) );
                    break;
                case self.CONST.STATE_DISPLAY.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 250, _dom, _dom );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE_AND_COLLAPSE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 250, _dom );
                    SHINKEN.TOOLS.TEST_AUTO.__hasClass( _dom, 'shinken-navbar-collapsed-menu-activated', "menu" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 250, self.DOM.getNavigationMenuCell( "shinken-collapsed-menu-cell", navigator ) );
                    break;
                default:
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.counter                             = function ( timeout, menu_name, nb_error, nb_warning, nb_total, nb_user ) {
        setTimeout( function () {
            var _counters = self.DOM.getNavigationCounters( menu_name );
            if ( nb_error !== undefined ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _counters[ "shinken-error-counter" ], nb_error );
            }
            //TODO
            //if ( nb_warning !== undefined ) {
            //    SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _window[ 2 ], nb_warning );
            //}
            //if ( nb_total !== undefined ) {
            //    SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _window[ 3 ], nb_total );
            //}
            //if ( nb_user !== undefined ) {
            //    SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _window[ 4 ], nb_user );
            //}
        }, timeout );
        return 100;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.logout                            = function ( timeout ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.logout', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getDisconnectButton() );
            }
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.openUserConfiguration             = function ( timeout ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.openUserConfiguration', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getUserConfigurationButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.setValueUserConfigurationProperty = function ( timeout, property_name, value ) {
        var _to_return = 250;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.setValueUserConfigurationProperty', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            switch ( property_name ) {
                case "blink":
                    SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.userConfigurationRadioButtonByName( null, property_name, value ) );
                    break;
                case "volume":
                    if ( value === "default" ) {
                        
                        SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.userConfigurationRadioButtonByName( null, property_name, value ) );
                    }
                    else {
                        CONTROLLER.NavigationBar.dropdown_configuration_user.property_volume.setValueFromUser( value );
                        CONTROLLER.UiVisualisation.doActionAfter( "change_value_notification_of_change_sound", value );
                    }
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnMenu                       = function ( timeout, menu_name, navigator ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnMenu', menu_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getNavigationMenu( menu_name, navigator ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnSubMenu                    = function ( timeout, menu_name, sub_menu_name, navigator ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnSubMenu', menu_name + " => " + sub_menu_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.mouseup( 0, self.DOM.getNavigationSubMenu( menu_name, sub_menu_name, navigator ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnAddFavorite                = function ( timeout ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnAddFavorite' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.mouseup( 0, self.DOM.getAddToFavoriteButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_MENU || {} );
