//__lib__ lib_common
//priority 100

'use strict';

SHINKEN_LIST.Line           = function () {
    this.init();
};
SHINKEN_LIST.Line.prototype = {
    init: function () {
        this.initContents();
        this.initPhase();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnInput         : function ( event ) {
        var _cell = this.getContentByEvent( event );
        if ( _cell ) {
            _cell.clickOnInput();
        }
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        var _cell = this.getContentByDomElement( dom_element );
        if ( _cell ) {
            _cell.askComputeAfterChange( dom_element, parent );
        }
    },
    clickOnItemSelector  : function ( event ) {
        var _cell = this.getContentByEvent( event );
        if ( _cell ) {
            _cell.clickOnItemSelector( event );
        }
    },
    //********************************************  GETTER BY EVENT  *****************************************************//
    getContentByDomElement: function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, 'shinken-list-cell', 20 );
        if ( !_parent_dom_element ) {
            return null;
        }
        return this.getContentByUUID( _parent_dom_element.dataset.uuid );
    },
    getContentByEvent     : function ( event ) {
        return this.getContentByDomElement( event.target );
    },
    //********************************************  FILTERS  *****************************************************//
    applyFilter                                        : function ( filters ) {
        var _filter = SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
        for ( var i = 0, _size_i = filters.length; i < _size_i; i++ ) {
            var _value_filter = filters[ i ].getValue();
            var _value_cell   = this.getCellValueForApplyFilter( filters[ i ].getName() );
            switch ( _value_cell ) {
                case SHINKEN_LIST.CONST.FILTER.HAS_CHILDREN:
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.HAS_CHILDREN;
                    continue;
            }
            var _type_filter = filters[ i ].type;
            switch ( _type_filter ) {
                case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                    _filter = this.getFilterStatusForSingleSelect( _value_filter, _value_cell, _filter );
                    break;
                case COMPONENT.CONST.TYPE.STRING_INPUT:
                case COMPONENT.CONST.TYPE.STRING_INPUT_WITH_DROPDOWN:
                    _filter = this.getFilterStatusForInputString( _value_filter, _value_cell, _filter );
                    break;
                case COMPONENT.CONST.TYPE.INPUT_STRING_ARRAY:
                    _filter = this.getFilterStatusForInputStringArray( _value_filter, _value_cell, _filter );
                    break;
            }
        }
        this.setFilter( _filter );
    },
    getFilterStatusForSingleSelect                         : function ( _value_filter, _value_cell, _filter ) {
        if ( _value_filter === SHINKEN_LIST.CONST.FILTER.ALL ) {
            return _filter;
        }
        else if ( _value_filter === SHINKEN_LIST.CONST.FILTER.NOT_EMPTY ) {
            if ( Array.isArray( _value_cell ) ) {
                if ( SHINKEN.TOOLS.ARRAY.contains( _value_cell, SHINKEN_LIST.CONST.FILTER.EMPTY ) ) {
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                }
            }
            else if ( _value_cell === SHINKEN_LIST.CONST.FILTER.EMPTY ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
            return _filter;
        }
        if ( Array.isArray( _value_cell ) ) {
            if ( !SHINKEN.TOOLS.ARRAY.contains( _value_cell, _value_filter ) ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( _value_cell !== _value_filter ) {
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
        }
        return _filter;
    },
    getFilterStatusForInputString: function ( _value_filter, _value_cell, _filter) {
        if ( SHINKEN.TOOLS.STRING.contains( _value_filter, "&" ) ) {
            var _values_filters = _value_filter.split( "&" );
            var _found          = false;
            for ( var j = 0, _size_j = _values_filters.length; j < _size_j; j++ ) {
                if ( SHINKEN.TOOLS.STRING_FILTER.containsIgnoreCase( _value_cell + "", _values_filters[ j ] ) ) {
                    _found = true;
                }
            }
            if ( !_found ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( _value_filter === '=""' ) {
            if ( _value_cell ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( _value_filter === '!=""' ) {
            if ( !_value_cell ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( SHINKEN.TOOLS.STRING.startsWith( _value_filter, "!" ) ) {
            if ( SHINKEN.TOOLS.STRING_FILTER.containsIgnoreCase( _value_cell + "", _value_filter.substr( 1 ) ) ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( !SHINKEN.TOOLS.STRING_FILTER.containsIgnoreCase( _value_cell + "", _value_filter ) ) {
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
        }
        return _filter;
    },
    getFilterStatusForInputStringArray                     : function ( _value_filter, _value_cell, _filter) {
        var _list  = _value_filter.split( "," );
        var _found = false;
        for ( var j = 0, _size_j = _list.length; j < _size_j; j++ ) {
            if ( _list[ j ] === _value_cell ) {
                _found = true;
                break;
            }
        }
        if ( !_found ) {
            return SHINKEN_LIST.CONST.FILTER.STATUS.ON;
        }
        else {
            return _filter;
        }
    },
    setFilter                                          : function ( to_set ) {
        this.is_filtered = to_set;
        switch ( this.is_filtered ) {
            case SHINKEN_LIST.CONST.FILTER.STATUS.ON:
                DOM.Service.addClasses( this.dom_element, "shinken-is-filtered" );
                break;
            case SHINKEN_LIST.CONST.FILTER.STATUS.OFF:
                DOM.Service.removeClasses( this.dom_element, "shinken-is-filtered" );
                break;
        }
        this.doActionAfterFilterChange();
    },
    doActionAfterFilterChange                          : function () {
    },
    isFiltered                                         : function () {
        return this.is_filtered === SHINKEN_LIST.CONST.FILTER.STATUS.ON;
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID                   : function () {
        return this.uuid;
    },
    toggleSelect              : function () {
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.OFF );
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
                break;
        }
    },
    setIsSelected             : function ( to_set ) {
        if ( this.is_filtered ) {
            return;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return;
        }
        this.is_selected = to_set;
        this.updateSelectionCounter();
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.dom_element.classList.add( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.add( "shinken-selected-parent" );
                }
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.dom_element.classList.remove( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.remove( "shinken-selected-parent" );
                }
                break;
        }
        if ( this.checkbox ) {
            this.checkbox.setChecked( this.is_selected );
        }
        
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                switch ( this.is_selected ) {
                    case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                        this.showCountersForParent();
                        break;
                    default:
                        this.hideCountersForParent();
                        break;
                }
        }
        
    },
    updateSelectionCounter    : function () {
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.is_selected_counter.update( this.uuid, this.isSelected() ? 1 : 0 );
                break;
        }
    },
    setDataSet                : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        if ( if_key ) {
            if ( if_function === "matching_regex" ) {
                if ( !SHINKEN.TOOLS.STRING.isMatchingStarRegexTab( this.getCellValue( if_key ), if_values ) ) {
                    data_value = else_data_value;
                }
            }
            else {
                if ( !SHINKEN.TOOLS.STRING.containsAny( this.getCellValue( if_key ), if_values ) ) {
                    data_value = else_data_value;
                }
            }
        }
        DOM.Service.setDataSet( this.dom_element, datakey, data_value );
    },
    isSelected                : function () {
        return this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON;
    },
    isSelectedOrFiltered      : function () {
        if ( this.is_filtered ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        return this.is_selected;
    },
    isCollapsedOrFiltered     : function () {
        if ( this.is_filtered ) {
            return true;
        }
        return this.is_collapse;
    },
    getData                   : function ( key ) {
        return this.dom_element.dataset[ key ];
    },
    getCellValue              : function ( key ) {
        return this.getContentByUUID( key ).getValue();
    },
    getCellValueForApplyFilter: function ( key ) {
        return this.getContentByUUID( key ).getValueForApplyFilter();
    },
    changeElementValue        : function ( key, to_set ) {
        if ( this.getContentByUUID( key ) !== undefined ) {
            this.dom_element.querySelector( '.shinken-list-cell[data-filter="' + key + '"]' ).innerHTML = to_set;
        }
    },
    simulateToggleSelect      : function () {
        this.dom_element.click();
    },
    isSibling                 : function ( list_line ) {
        return (list_line.parent_uuid === this.parent_uuid && list_line.uuid === this.uuid);
    },
    setIndexOriginal          : function ( to_set ) {
        this.index_origin = to_set;
    },
    //********************************************  COLLAPSE  *****************************************************//
    toggleCollapse        : function ( childrens ) {
        this.setIsCollapsed( !this.is_collapse );
        for ( var i = 0, _size_i = childrens.length; i < _size_i; i++ ) {
            childrens[ i ].setIsCollapsed( this.is_collapse );
        }
    },
    setIsCollapsed        : function ( to_set, childrens ) {
        this.is_collapse = to_set;
        if ( this.is_collapse ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
        if ( childrens ) {
            for ( var i = 0, _size_i = childrens.length; i < _size_i; i++ ) {
                childrens[ i ].setIsCollapsed( this.is_collapse );
            }
        }
    },
    simulateToggleCollapse: function () {
        DOM.Service.SimulateAction.click( this.dom_element.querySelector( ".shinken-collapse-listener" ) );
    },
    //********************************************  SAVE  *****************************************************//
    getDataToExport             : function ( headers ) {
        var _to_return = [];
        var _current;
        for ( var i = 0, _size_i = headers.length; i < _size_i; i++ ) {
            _to_return.push( this.getCellValue( headers[ i ] ) || "" );
        }
        return _to_return;
    },
    updateAfterActionDoneOK     : function ( action ) {
        this.setMessages();
        var _current = this.getContentByUUID( this.parseToFindCellUuid( action.key ) );
        _current.updateAfterActionDoneOK( action );
        this.addMessages( _current.getMessages() );
        this.extraActionAfterActionDoneOK( action );
    },
    extraActionAfterActionDoneOK: function ( action ) {
    },
    extraActionAfterDone        : function ( data ) {
    },
    updateAfterActionDoneNOK    : function ( action ) {
        this.setMessages();
        var _current = this.getContentByUUID( this.parseToFindCellUuid( action.key ) );
        _current.updateAfterActionDoneNOK( action );
        this.addMessages( _current.getMessages() );
    },
    parseToFindCellUuid         : function ( key ) {
        return key;
    },
    //********************************************  OTHERS *****************************************************//
    applySiblingSettings  : function ( list_line ) {
        if ( this.isSelected() !== list_line.isSelected() ) {
            this.simulateToggleSelect();
        }
        if ( this.is_collapse !== list_line.is_collapse ) {
            this.simulateToggleCollapse();
        }
        DOM.Service.applySiblingSettings( this.dom_element, list_line.dom_element );
    },
    cancelUserModification: function () {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).cancelUserModification();
        }
    },
    remove                : function () {
        if ( this.dom_element ) {
            DOM.Service.removeElement( this.dom_element );
        }
        this.resetCounters();
    },
    getObjectsType        : function () {
        return "shinken-list-cell";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Line, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Line, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Line, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
