//__lib__ lib_common
'use strict';


MANAGER.DistributorControllerManager = (function ( self ) {
    "use strict";
    self.findControllerByEvent = function ( event, controller_name ) {
        var _controller_name = controller_name || self.findControllerName( event );
        if ( !_controller_name ) {
            return;
        }
        return MANAGER.DistributorControllerManager.getController( _controller_name );
    };
    self.findControllerName = function ( event, dom_element ) {
        if ( !event && !dom_element) {
            return;
        }
        var _target             = dom_element || event.target;
        var _parent_dom_element = DOM.Service.findParentElementWithClass( _target, "shinken-parent-event-listener", 500 );
        if ( !_parent_dom_element ) {
            return;
        }
        return _parent_dom_element.dataset.controller;
    };
    self.getController         = function ( _controller ) {
        switch ( _controller ) {
            case MANAGER.CONST.CONTROLLER.MASS_CHANGE:
                return CONTROLLER.MassChange;
            case MANAGER.CONST.CONTROLLER.LIST_ALL:
                return CONTROLLER.List;
            case MANAGER.CONST.CONTROLLER.SHINKEN_ELEMENT:
                return CONTROLLER.ShinkenElement;
            case MANAGER.CONST.CONTROLLER.SOURCES:
                return CONTROLLER.Source;
            case MANAGER.CONST.CONTROLLER.MAIN:
                return CONTROLLER.Main;
            case MANAGER.CONST.CONTROLLER.APPLY:
                return CONTROLLER.Apply;
            case MANAGER.CONST.CONTROLLER.WEATHER:
                return CONTROLLER.Weather;
            case MANAGER.CONST.CONTROLLER.COMMON_UI:
                return CONTROLLER.CommonUI;
            case MANAGER.CONST.CONTROLLER.UI_VISUALISATION:
                return CONTROLLER.UiVisualisation;
            case MANAGER.CONST.CONTROLLER.UI_PANELS:
                return CONTROLLER.UiPanels;
            case MANAGER.CONST.CONTROLLER.UI_PANELS_VIEW:
                return CONTROLLER.UiPanelsView;
            case MANAGER.CONST.CONTROLLER.UI_VIEW_WEATHER_MANAGER:
                return CONTROLLER.UiViewWeatherManager;
            case MANAGER.CONST.CONTROLLER.UI_LOGIN:
                return CONTROLLER.Login;
            case "SHINKEN-TODO":
                break;
            default:
                console.warn( "NO CONTROLLER FOUND FOR ", "[" + _controller + "]" );
        }
    };
    return self;
})( MANAGER.DistributorControllerManager || {} );

