//__lib__ lib_common
'use strict';

SHINKEN.OBJECT.Param           = function ( key, value_object, parameter, default_value ) {
    this.init( key, value_object, parameter, default_value );
};
SHINKEN.OBJECT.Param.prototype = {
    init                    : function ( key, value_object, parameter, default_value ) {
        this.__class_name__ = 'SHINKEN.OBJECT.Param';
        this.initCounters();
        if ( ! value_object ){
            console.warn( "[Param - init FAILED]", key, value_object, parameter, default_value );
            return;
        }
        if ( value_object.validation_messages ){
            this.setMessages( value_object.validation_messages );
        }
        this.key        = key;
        this.setValue(value_object.value);
        this.cfg_value  = value_object.cfg_value;
        this.setUserValue( value_object.source_value === undefined ? "" : value_object.source_value );
        if ( parameter && this.user_value === "" && !parameter.is_mandatory ) {
            this.user_value = default_value;
        }
    },
    doActionAfterAddMessages: function () {
        this.setWarning( this.getObjectClassName(), this.messages.getNumberWarnings() );
        this.setError( this.getObjectClassName(), this.messages.getNumberErrors() );
    },
    _getObjectToJson: function () {
        return this;
    },
    getUserValue            : function () {
        return this.user_value;
    },
    setUserValue                : function ( to_set ) {
        this.user_value = to_set;
    },
    setValue                : function ( to_set ) {
        this.value = to_set;
    },
    getValue                : function () {
        return this.value;
    },
    getUUID                 : function () {
        return this.uuid;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Param, SHINKEN.OBJECT.CounterInterfaceValidation );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Param, SHINKEN.OBJECT.ShinkenObjectJson );
