// When there is a massive action, and so we are disabling the fact that the user can get out the page
var __massive_action_in_progress = false;

// Collapse all elements of this changed=>type.
function apply_collapse_all ( type ) {
    var _current_link;
    var _current_id;
    var _current_collapse_status;
    var collapse_links = document.querySelectorAll( '.apply_type_collapse_' + type );
    
    for ( var i = 0, _size_collapse_links = collapse_links.length; i < _size_collapse_links; i++ ) {
        _current_link            = collapse_links[ i ];
        _current_id              = _current_link.dataset[ 'id' ];
        _current_collapse_status = _current_link.dataset[ 'collapsed' ];
        if ( _current_collapse_status === 'true' ) {
            show_change_table( _current_id );
            _current_link.dataset[ 'collapsed' ] = false;
        }
        else {
            hide_change_table( _current_id );
            _current_link.dataset[ 'collapsed' ] = true;
        }
    }
    
    // At the end change the <i> from the collapse all button
    var i = $( '#i-collapse-type-' + type );
    
    i.toggleClass( 'icon-minus' );
    i.toggleClass( 'icon-plus' );
    
    
}

function toggle_change_table ( _id ) {
    //$('#'+_id).toggleClass("hide");    
    if ( $( '#' + _id ).hasClass( 'hide' ) ) {
        show_change_table( _id );
    }
    else {
        hide_change_table( _id );
    }
}

function hide_change_table ( _id ) {
    $( '#' + _id ).addClass( "hide" );
    var i = $( '#i-changes-table-' + _id );
    i.addClass( 'icon-plus' ).removeClass( 'icon-minus' );
}

function show_change_table ( _id ) {
    $( '#' + _id ).removeClass( "hide" );
    var i = $( '#i-changes-table-' + _id );
    i.removeClass( 'icon-plus' ).addClass( 'icon-minus' );
    
}

// By default show all
var filter_part = 'all';
var filter_type = 'all';

// The user ask for a filter part: do it fagot!
function set_filter_part ( part ) {
    filter_part = part;
    update_block_after_filter();
}

// The user ask for a filter part: do it fagot!
function set_filter_type ( type ) {
    filter_type = type;
    update_block_after_filter();
}

// Update right blocks visibility after we did change it
function update_block_after_filter () {
    // visually highlight the li "button", after unlight all
    $( '.li-filter' ).removeClass( 'active' );
    // Only activate to the valid ones
    $( '#li-to-type-' + filter_type ).addClass( 'active' );
    $( '#li-to-part-' + filter_part ).addClass( 'active' );
    
    var block_groups = $( '.block-grp' );
    for ( var i = 0; i < block_groups.length; i++ ) {
        var block       = $( block_groups[ i ] );
        var part        = block.data( 'part' );
        var type        = block.data( 'type' );
        var sub_block   = block.find( '.apply-element-block' );
        var nb_elements = sub_block.data( 'nb-elements' );
        // Maybe there is no elements on this part, if so hide it!
        if ( nb_elements == '0' ) {
            block.hide();
            continue; // bail out, this block is void
        }
        var display = false; // by default hide it unless true
        if ( filter_part == 'all' || part == filter_part ) {
            if ( filter_type == 'all' || type == filter_type ) {
                display = true;
            }
        }
        if ( display ) {
            block.show();
        }
        else {
            block.hide();
        }
    }
    
    // also look a the block-grp-part that are new/change/removed in whole
    var block_grp_parts = $( '.block-grp-part' );
    for ( var i = 0; i < block_grp_parts.length; i++ ) {
        var block = $( block_grp_parts[ i ] );
        var part  = block.data( 'part' );
        if ( filter_part == 'all' || part == filter_part ) {
            block.show();
        }
        else {
            block.hide();
        }
    }
    
    // Update numbers on the UL/LI parts too
    var parts          = ['new', 'changed', 'removed'];
    var total_by_type  = {}; // total of elements, sort by type (host, commmand, etc etc), and what ever filtered is
    var total_all_part = 0;  // total of values for all parts
    var total_all_type = 0;  // total of values for all types
    for ( var i = 0; i < parts.length; i++ ) {
        var part = parts[ i ];
        
        // Maybe it's not a part that is already selected, if so skip it
        if ( filter_part != 'all' && part != filter_part ) {
            continue;
        }
        
        var obj               = g_nb_elements[ part ];
        var total             = 0; // local total of this part (new, changed, removed), without the filter used
        var total_with_filter = 0; // local total of this part (new, changed, removed), but with the filters use
        
        for ( var type in obj ) {
            if ( obj.hasOwnProperty( type ) ) {
                if ( typeof total_by_type[ type ] == 'undefined' ) {
                    total_by_type[ type ] = 0;
                }
                total_by_type[ type ] += obj[ type ];
                
                total += obj[ type ]; // But we still want the overall
                // But only count on the total with filter if the filter match
                if ( filter_type == 'all' || filter_type == type ) {
                    total_with_filter += obj[ type ];
                }
                
                // We know  for this type AND part the number, update the right part now
                $( '#apply-right-nb-' + part + '-' + type ).html( '[&nbsp;' + obj[ type ] + '&nbsp;]' );
                
            }
        }
        // Now we can update the total for this part
        $( '#nb-' + part ).html( '[ ' + total + ' ]' );
        // And in the right part too, but this one is counting with filters :)
        $( '#apply-right-nb-' + part ).html( '[ ' + total_with_filter + ' ]' );
        // If this right part is with 0 elements, just hide it
        if ( total_with_filter != 0 ) {
            $( '#apply-right-block-' + part ).show();
        }
        else {
            $( '#apply-right-block-' + part ).hide();
        }
    }
    // Now we did parse all the tree, we know the total for each type, we can update display
    
    var hidden_selected = false;
    for ( type in total_by_type ) {
        if ( !total_by_type.hasOwnProperty( type ) ) {
            continue;
        }
        // Update the type number value aside the type name
        var nb = total_by_type[ type ];
        $( '#nb-' + type ).html( '[ ' + nb + ' ]' );
        if ( nb == 0 ) {
            $( '#li-to-type-' + type ).hide();
            // WARNING: maybe we are hidden a selected element, if so, get back to All selector!
            // BEWARE OF ENDLESS LOOP, but do not ssem to have any
            if ( type == filter_type ) {
                hidden_selected = true;
            }
        }
        else { // Be sure to display it, maybe it was hide before
            $( '#li-to-type-' + type ).show();
        }
    }
    // If we did hide a selected filter, force
    if ( hidden_selected ) {
        set_filter_type( 'all' );
    }
}

// WHEN we did reload, we say it in the url, take it and show a message :)
function getParameterByName ( name ) {
    name        = name.replace( /[\[]/, "\\[" ).replace( /[\]]/, "\\]" );
    var regex   = new RegExp( "[\\?&]" + name + "=([^&#]*)" ),
        results = regex.exec( location.search );
    return results === null ? "" : decodeURIComponent( results[ 1 ].replace( /\+/g, " " ) );
}

function form_check_success_rc_error ( arg1 ) {
    
    if ( !arg1.text ) {
        addErrorChecking( _( "apply.error_empty_json" ) );
        return;
    }
    try {
        var matrix = JSON.parse( arg1.text );
    }
    catch (e) {
        addErrorChecking( _("apply.error_invalid_json") );
        return;
    }
    
    var _to_return = [];
    var _to_add;
    
    for ( var i = 0, _size_i = matrix.length; i < _size_i; i++ ) {
        _to_add                                                    = {};
        _to_add[ 'id' ]                                            = matrix[ i ][ 0 ];
        _to_add[ 'message_type' ]                                  = matrix[ i ][ 1 ];
        _to_add[ SHINKEN_LIST.APPLY_MSG.HEADERS.ERROR_LEVEL._KEY ] = matrix[ i ][ 2 ];
        _to_add[ SHINKEN_LIST.APPLY_MSG.HEADERS.MESSAGE._KEY ]     = matrix[ i ][ 3 ];
        
        switch ( _to_add[ 'message_type' ] ) {
            case "ELEMENT" :
                var json_type = matrix[ i ][ 4 ];
                var type;
                switch ( json_type ) {
                    case "hosttpls":
                        type = "hosts";
                        break;
                    default:
                        type = json_type;
                        break;
                }
                _to_add[ SHINKEN_LIST.APPLY_MSG.HEADERS.TYPE._KEY ] = json_type;
                _to_add[ 'link' ]                                   = SHINKEN.TOOLS.Link.parse_to_link( type, matrix[ i ][ 5 ], matrix[ i ][ 6 ] );
                break;
            case "LICENCE" :
                _to_add[ SHINKEN_LIST.APPLY_MSG.HEADERS.TYPE._KEY ] = "LICENCE";
                break;
            case "RAW" :
                _to_add[ SHINKEN_LIST.APPLY_MSG.HEADERS.TYPE._KEY ] = "";
                break;
            default:
                //console.log( "VBET", "[form_check_success_rc_error - form_check_success_rc_error]", "TYPE NOT MANAGED", _to_add[ 'message_type' ] );
                break;
        }
        
        _to_return.push( _to_add );
    }
    CONTROLLER.Apply.initSetApplyMsg( _to_return );
}

function click_on_toggle_error_panel_size () {
    if ( _element_left_column.dataset.state === __STATE_ACTION_AREA_CHECKING_LOG_ERROR_DISCREET ) {
        set_left_column_state( __STATE_ACTION_AREA_CHECKING_LOG_ERROR_FULL );
    }
    else {
        set_left_column_state( __STATE_ACTION_AREA_CHECKING_LOG_ERROR_DISCREET );
    }
}

function click_on_close_error_panel_size () {
    set_left_column_state( __STATE_ACTION_AREA_NONE );
}

function form_restart_success ( arg1 ) {
    var rc = arg1.rc;
    if ( rc === 0 ) {
        update_check_apply_log( __CALL_RELOAD );
    }
    else {
        var text = arg1.text.replace( /<(?:.|\n)*?>/gm, '' );
        addErrorChecking( '<b>' + _( 'apply.restart_error' ) + '</b>' + text + '' );
    }
}

function isArbiterReloading ( data ) {
    return (data.master_reloading !== undefined && data.master_reloading !== false);
}

function really_click_on_restart_configuration () {
    MANAGER.ApplySize.reset();
    set_left_column_state( __STATE_ACTION_AREA_NONE );
    update_check_apply_log( __CALL_CHECK_FULL, function () {
        update_check_apply_log( __CALL_COMMIT_FULL );
    } );
}

function checkArbiters () {
    var jqxhr = $.ajax( {
        url: '/apply/check_arbiters'
    } );
    return jqxhr;
}

function retryCheckArbiters ( data, element, call_path ) {
    var _has_spare            = (data.spare !== undefined && data.spare === true);
    var _is_arbiter_down      = !(data.master !== undefined && data.master === true);
    var _is_arbiter_reloading = isArbiterReloading( data );
    
    //console.log( '_has_spare[', _has_spare, '] - _is_arbiter_down[', _is_arbiter_down, '] - _is_arbiter_reloading[', _is_arbiter_reloading, '] - from:', data );
    
    if ( _is_arbiter_reloading ) {
        call_path = __CALL_RELOAD;
        set_left_column_state( __STATE_ACTION_AREA_MASTER_IS_RELOADING );
    }
    else if ( _is_arbiter_down && _has_spare ) {
        set_left_column_state( __STATE_ACTION_AREA_NO_MASTER_WITH_SPARE );
    }
    else if ( _is_arbiter_down ) {
        set_left_column_state( __STATE_ACTION_AREA_NO_MASTER );
    }
    else {
        set_left_column_state( __STATE_ACTION_AREA_NONE );
    }
    askCheckArbiters( element, call_path );
}

var _timerAsk;
var _timerCheckArbiters        = 1000; // 1 secondes
var _timerCheckArbitersMax     = 5000; // 5 secondes
var _timerCheckArbitersBeganTo = 0;
var _timerCheckArbitersLimit   = 1200; // 20 Minutes

function askCheckArbiters ( element, call_path ) {
    var _timeNow = Math.floor( new Date().getTime() / 1000 );
    if ( !_timerCheckArbitersBeganTo ) {
        _timerCheckArbitersBeganTo = _timeNow;
    }
    if ( _timerAsk ) {
        clearTimeout( _timerAsk );
    }
    _timerAsk = setTimeout( function () {
        _timerCheckArbiters = (_timerCheckArbiters < _timerCheckArbitersMax) ? _timerCheckArbiters * 1.10 : _timerCheckArbitersMax;
        if ( (_timeNow - _timerCheckArbitersBeganTo) >= _timerCheckArbitersLimit ) {
            clearTimeout( _timerAsk );
            //console.log( "[askCheckArbiters] ------- stop", _timerCheckArbiters );
        }
        else {
            _timerAsk = null;
            //console.log( "[askCheckArbiters] - start", _timerCheckArbiters );
            check_configuration( element, call_path );
        }
    }, _timerCheckArbiters );
}

function update_check_apply_log ( call_path, callback_success, callback_failed ) {
    var _state         = __STATE_ACTION_AREA_NONE;
    var _success_state = __STATE_ACTION_AREA_NONE;
    var _failed_state  = __STATE_ACTION_AREA_NONE;
    
    if ( getParameterByName( 'reload' ) === 'OK' ) {
        _state = __STATE_ACTION_AREA_RELOAD_OK;
        _cleanUrlWithParam();
    }
    switch ( call_path ) {
        case __CALL_CHECK_FULL:
        case __CALL_CHECK_PROPOSE:
            _state         = __STATE_ACTION_AREA_CHECKING;
            _success_state = __STATE_ACTION_AREA_CHECKING_OK;
            _failed_state  = __STATE_ACTION_AREA_CHECKING_NOK;
            break;
        case __CALL_COMMIT_FULL:
            _state           = __STATE_ACTION_AREA_APPLY_IN_PROGRESS;
            callback_success = function () {
                update_check_apply_log( __CALL_RESTART );
            };
            callback_failed  = function ( arg1 ) {
                addErrorChecking( arg1.status === 400 ? _( 'apply.bad_query' ) : _( 'apply.error_save' ) + ' ' + arg1.status + ' ' + arg1.statusText );
            };
            break;
        case __CALL_CHECK_FULL_FORCED:
            clearTimeout( _timerAsk );
            _state         = __STATE_ACTION_AREA_CHECKING_NO_MASTER;
            _success_state = __STATE_ACTION_AREA_CHECKING_OK_NO_MASTER;
            _failed_state  = __STATE_ACTION_AREA_CHECKING_NOK_NO_MASTER;
            call_path      = __CALL_CHECK_FULL;
            break;
        case __CALL_COMMIT_FULL_FORCED:
            _state           = __STATE_ACTION_AREA_APPLY_IN_PROGRESS_NO_MASTER;
            _success_state   = __STATE_ACTION_AREA_APPLY_IN_PROGRESS_OK_NO_MASTER;
            _failed_state    = __STATE_ACTION_AREA_APPLY_IN_PROGRESS_NOK_NO_MASTER;
            call_path        = __CALL_COMMIT_FULL;
            callback_success = function () {
                location.assign( '/apply?reload=FORCE_OK&ts=' + Date.now() );
            };
            callback_failed  = function ( arg1 ) {
                addErrorChecking( arg1.status === 400 ? _( 'apply.bad_query' ) : _( 'apply.error_save' ) + ' ' + arg1.status + ' ' + arg1.statusText );
            };
            break;
        case __CALL_RESTART:
            _state           = __STATE_ACTION_AREA_CHECKING_APPLY;
            callback_success = form_restart_success;
            callback_failed  = function ( arg1 ) {
                addErrorChecking( arg1.status === 400 ? _( 'apply.bad_query' ) : _( 'apply.error_save' ) + ' ' + arg1.status + ' ' + arg1.statusText );
            };
            break;
        case __CALL_RELOAD:
            location.assign( '/apply?reload=OK&ts=' + Date.now() );
            return;
    }
    
    set_left_column_state( _state );
    if ( !call_path ) {
        return;
    }
    
    $.get( call_path + '?ts=' + Date.now() )
     .success( function ( result ) {
         if ( !result || result.rc === 0 ) {
             set_left_column_state( _success_state );
             if ( callback_success ) {
                 callback_success( result );
             }
         }
         else {
             form_check_success_rc_error( result );
         }
     } )
     .error( function ( response ) {
             set_left_column_state( _failed_state );
             if ( callback_failed ) {
                 callback_failed( response );
             }
             else {
                 if ( response.status === 0 ) {
                     console.error( 'The apply page returns an error with status  ' + response.status );
                 }
                 else {
                     addErrorChecking( response.status === 400 ? _( 'apply.bad_query' ) : _( 'apply.error_save' ) + ' ' + response.status + ' ' + response.statusText );
                 }
             }
         }
     );
}

function _cleanUrlWithParam () {
    var _url = location.protocol + '//' + location.host + location.pathname;
    history.pushState( null, '', _url );
}

function init () {
    _element_left_column = document.getElementById( "id-shinken-left-column" );
    
    if ( getParameterByName( 'reload' ) === 'FORCE_OK' ) {
        set_left_column_state( __STATE_ACTION_AREA_APPLY_IN_PROGRESS_OK_NO_MASTER );
        _cleanUrlWithParam();
        return;
    }
    
    check_configuration();
    MANAGER.__instance_loading.setIsReady( true );
}

var _element_left_column;

var __STATE_ACTION_AREA_NONE                            = "";
var __STATE_ACTION_AREA_RELOAD_OK                       = "reloading";
var __STATE_ACTION_AREA_CHECKING                        = "checking";
var __STATE_ACTION_AREA_CHECKING_NO_MASTER              = "checking-no-master";
var __STATE_ACTION_AREA_CHECKING_OK                     = "checking_ok";
var __STATE_ACTION_AREA_CHECKING_OK_NO_MASTER           = "checking-ok-no-master";
var __STATE_ACTION_AREA_CHECKING_NOK                    = "checking_nok";
var __STATE_ACTION_AREA_CHECKING_NOK_NO_MASTER          = "checking-nok-no-master";
var __STATE_ACTION_AREA_APPLY_IN_PROGRESS               = "apply-in-progress";
var __STATE_ACTION_AREA_APPLY_IN_PROGRESS_NO_MASTER     = "apply-in-progress-no-master";
var __STATE_ACTION_AREA_APPLY_IN_PROGRESS_OK_NO_MASTER  = "apply-in-progress-ok-no-master";
var __STATE_ACTION_AREA_APPLY_IN_PROGRESS_NOK_NO_MASTER = "apply-in-progress-nok-no-master";
var __STATE_ACTION_AREA_CHECKING_APPLY                  = "checking_apply";
var __STATE_ACTION_AREA_NO_MASTER                       = "no-master";
var __STATE_ACTION_AREA_NO_MASTER_WITH_SPARE            = "no-master-with-spare";
var __STATE_ACTION_AREA_MASTER_IS_RELOADING             = "reloading-in-progress";
var __STATE_ACTION_AREA_CHECKING_LOG_ERROR_FULL         = "checking_log_error_full";
var __STATE_ACTION_AREA_CHECKING_LOG_ERROR_DISCREET     = "checking_log_error_discreet";
var __CALL_CHECK_PROPOSE                                = "/apply/check_proposed";
var __CALL_CHECK_FULL                                   = "/apply/check";
var __CALL_CHECK_FULL_FORCED                            = "/apply/check_forced";
var __CALL_COMMIT_FULL                                  = "/apply/commit";
var __CALL_COMMIT_FULL_FORCED                           = "/apply/commit_forced";
var __CALL_RESTART                                      = "/apply/restart";
var __CALL_RELOAD                                       = "apply/reload";

function set_left_column_state ( to_set ) {
    DOM.Service.setDataSet( _element_left_column, 'state', to_set );
}

function addErrorChecking ( _html ) {
    set_left_column_state( __STATE_ACTION_AREA_CHECKING_NOK );
    var _element       = document.getElementById( 'checking-is-nok' );
    _element.innerHTML = _html;
}

function click_on_check_configuration_propose ( element ) {
    MANAGER.ApplySize.reset();
    check_configuration( element, __CALL_CHECK_PROPOSE );
}

function click_on_check_configuration ( element ) {
    if ( element.classList.contains( 'btn-disabled' ) ) {
        return;
    }
    MANAGER.ApplySize.reset();
    check_configuration( element, __CALL_CHECK_FULL );
}

function click_on_force_configuration ( element ) {
    if ( element.classList.contains( 'btn-disabled' ) ) {
        return;
    }
    MANAGER.ApplySize.reset();
    update_check_apply_log( __CALL_CHECK_FULL_FORCED, function () {
        update_check_apply_log( __CALL_COMMIT_FULL_FORCED );
    } );
}

function click_on_restart_configuration ( element ) {
    var _promise = checkArbiters();
    _promise.done( function ( data ) {
        if ( isArbiterReloading( data ) ) {
            retryCheckArbiters( data, element );
            return;
        }
        
        set_left_column_state( __STATE_ACTION_AREA_NONE );
        var nb_changes = 0;
        var nb_parts   = {};
        
        for ( var part in g_nb_elements ) {
            nb_parts[ part ] = 0;
            if ( g_nb_elements.hasOwnProperty( part ) ) {
                for ( var type in g_nb_elements[ part ] ) {
                    if ( g_nb_elements[ part ].hasOwnProperty( type ) ) {
                        nb_changes += g_nb_elements[ part ][ type ];
                        nb_parts[ part ] += g_nb_elements[ part ][ type ];
                    }
                }
            }
        }
        
        if ( nb_changes > 0 ) {
            var s = _( 'apply.sure_apply' ) + ' ' + nb_changes + ' (';
            s += _( 'apply.new' ) + ': [' + nb_parts[ 'new' ] + ']';
            s += ', ' + _( 'apply.changed' ) + ': [' + nb_parts[ 'changed' ] + ']';
            s += ', ' + _( 'apply.removed' ) + ': [' + nb_parts[ 'removed' ] + ']';
            s += ') ' + _( 'apply.updates_prod' );
            
            if ( confirm( s ) ) {
                really_click_on_restart_configuration();
            }
        }
    } );
    _promise.fail( function ( XMLHttpRequest, textStatus, errorThrown ) {
        retryCheckArbiters( JSON.parse( XMLHttpRequest.responseText ), element );
    } );
}


function check_configuration ( element, call_path ) {
    var _promise = checkArbiters();
    _promise.done( function ( data ) {
        if ( isArbiterReloading( data ) ) {
            retryCheckArbiters( data, element );
            return;
        }
        set_left_column_state( __STATE_ACTION_AREA_NONE );
        update_check_apply_log( call_path );
    } );
    _promise.fail( function ( XMLHttpRequest, textStatus, errorThrown ) {
        retryCheckArbiters( JSON.parse( XMLHttpRequest.responseText ), element, call_path );
    } );
}


//********************************************  DOM IS READY   ******************************************************//
var doActionWhenDomReady = function ( e ) {
    window.onbeforeunload = function () {
        if ( __massive_action_in_progress ) {
            return _( 'apply.actions_progress' );
        }
    };
    var right_block       = $( '#apply-right-block' );
    var elements_blocks   = $( '.apply-element-block' );
    for ( var i = 0; i < elements_blocks.length; i++ ) {
        var block = $( elements_blocks[ i ] );
        block.detach();
        var part         = block.data( 'part' );
        var type         = block.data( 'type' );
        var target_block = $( '#apply-right-block-' + part + '-' + type );
        target_block.append( block );
    }
    
    // Also pass the whole update part, so we are ok with future filters
    update_block_after_filter();
    init();
};

SHINKEN.ApplyMessage           = function ( string ) {
    //date
    //type
    this.string_original         = string;
    this.string_original_content = string.substring( 28, string.length - 1 );
    this.init();
};
SHINKEN.ApplyMessage.prototype = {
    init      : function () {
        if ( this.string_original ) {
            this.setType();
            this.setDate();
            this.setRealm();
            this.setText();
        }
    },
    setType   : function () {
        if ( SHINKEN.TOOLS.STRING.contains( this.string_original, '[33m' ) ) {
            this.type = "WARNING";
        }
        else if ( SHINKEN.TOOLS.STRING.contains( this.string_original, '[31m' ) ) {
            this.type = "ERROR";
        }
    },
    setDate   : function () {
        this.date = this.string_original.substring( 7, 26 );
    },
    setRealm  : function () {
        this.realm = SHINKEN.TOOLS.STRING.extractBetween( this.string_original_content, "[", "]" ).trim();
    },
    setText   : function () {
        var _index = this.string_original_content.indexOf( "]" );
        this.text  = this.string_original_content.substring( _index + 2 );
    },
    buildClass: function () {
        this.class = "";
        switch ( this.type ) {
            case "WARNING":
                this.class += 'warning-line';
                break;
            case "ERROR":
                this.class += 'error-line';
                break;
        }
    },
    buildHtml : function () {
        this.buildClass();
        var _tr = DOM.Service.createElement( 'tr', { class: this.class } );
        _tr.appendChild( DOM.Service.createElement( 'td', {}, this.date ) );
        _tr.appendChild( DOM.Service.createElement( 'td', {}, this.type ) );
        _tr.appendChild( DOM.Service.createElement( 'td', {}, this.realm ) );
        _tr.appendChild( DOM.Service.createElement( 'td', { class: 'shinken-table-text' }, this.text ) );
        return _tr;
    }
};