//priority 1
//__lib__ lib_external

var SHINKEN = {};

SHINKEN.DOM = {};

SHINKEN.MODAL     = {};
SHINKEN.NAVIGATOR = SHINKEN.NAVIGATOR || {};
SHINKEN.PAGE      = {};

SHINKEN.TOOLS            = {};
SHINKEN.TOOLS.ARRAY      = {};
SHINKEN.TOOLS.ENCRYPTION = {};
SHINKEN.OBJECT           = {};

var DOM   = {};
DOM.CONST = {};

SHINKEN.CONST = {
    KEY_CODE : {
        TAB   : 9,
        ENTER : 13,
        ESCAPE: 27,
        SPACE : 32,
        LEFT  : 37,
        UP    : 38,
        RIGHT : 39,
        DOWN  : 40,
        F1    : 112
    }
};



SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin = function ( link, id, label, _class, tooltip ) {
    if ( MANAGER.__instance_element_distributor.current_user.is_admin && link && id ) {
        return SHINKEN.TOOLS.buildLinkDomElement( link, id, label, _class, tooltip );
    }
    if ( !_class ) {
        _class = "title shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'span', { class: _class }, label );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkDomElement              = function ( link, id, label, _class, tooltip ) {
    var _href = "/elements/" + link + '/' + id;
    if ( !_class ) {
        _class = "title shinken-link shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'a', { class: _class, href: _href, draggable: 'false', target: "_blank", onclick: "MANAGER.EventManager.mutePropagation(event)" }, '<span class="shinken-tag-label">' + label + '</span>' );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkShinkenElement          = function ( element, label, _class, tooltip ) {
    var _uuid = element.uuid;
    if ( element.isNew() ) {
        _uuid += '?new=1';
    }
    if ( !label ) {
        label = element.getName();
    }
    return SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( element.getType(), _uuid, label, _class, tooltip );
};
