//__lib__ lib_external
'use strict';


MANAGER.DistributorControllerManager = (function ( self ) {
    "use strict";
    self.findControllerByEvent = function ( event, controller_name ) {
        var _controller = controller_name;
        if ( !_controller ) {
            var _target             = event.target;
            var _parent_dom_element = DOM.Service.findParentElementWithClass( _target, "shinken-parent-event-listener", 500 );
            if ( !_parent_dom_element ) {
                //console.warn("[findControllerByEvent]", "[NO PARENT ELEMENT FOUND WITH CLASS 'shinken-parent-event-listener']"  );
                //console.warn("[controller will not work]" );
                return;
            }
            _controller = _parent_dom_element.dataset.controller;
        }
        return self.getController(_controller);
    };
    self.getController         = function ( _controller ) {
        switch ( _controller ) {
            case MANAGER.CONST.CONTROLLER.MASS_CHANGE:
                return CONTROLLER.MassChange;
            case MANAGER.CONST.CONTROLLER.LIST_ALL:
                return CONTROLLER.List;
            case MANAGER.CONST.CONTROLLER.SHINKEN_ELEMENT:
                return CONTROLLER.ShinkenElement;
            case MANAGER.CONST.CONTROLLER.SOURCES:
                return CONTROLLER.Source;
            case "SHINKEN-TODO":
                break;
            default:
                //console.warn( "NO CONTROLLER FOUND FOR ", "[" + _controller + "]" );
                break;
        }
    };
    return self;
})( MANAGER.DistributorControllerManager || {} );

