'use strict';

PROPERTY.Range           = function ( dom_element ) {
    // active
    // dom_element
    // name
    // value
    // inherited_value
    // default_value
    // is_null_value
    // type
    // component_input_range
    // component_btn_default
    // component_btn_inheritance
    // state
    // state_inheritance
    // tab_parent_id
    this.init( dom_element );
};
PROPERTY.Range.prototype = {
    init: function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_input_range       = new COMPONENT.InputRange( dom_element, this );
        this.component_btn_default       = new COMPONENT.Button( dom_element.querySelector( ".shinken-btn-default-cell .shinken-radio-btn" ), PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
        this.component_btn_default.value = this.default_value === 'same_as_host' ? '' : this.default_value;
        if ( this.is_override ) {
            this.component_btn_no_override       = new COMPONENT.Button( dom_element.querySelector( ".shinken-no-override-btn" ) );
            this.component_btn_no_override.value = this.component_btn_no_override.dom_element.dataset.checkValue;
            if ( this.component_btn_no_override.value ) {
                this.component_btn_no_override.value = parseInt( this.component_btn_no_override.value )
            }
        }
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    onMoveRangeCursor           : function ( value_to_set, event, is_synchro ) {
        if ( this.is_disabled ) {
            return;
        }
        if ( this.is_mass_change && !is_synchro && this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue() === PROPERTY.CONST.MASS_CHANGE.ACTION.SET_SYNCHRO ) {
            var self = this;
            setTimeout( function () {
                var _value = self.component_input_range.getValue();
                self.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION.SET, null, self.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
                self.setValueFromUser( _value );
            }, 200 );
        }
        if ( value_to_set !== null ) {
            switch ( this.type ) {
                case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                    value_to_set = SHINKEN.TOOLS.NUMBER.roundTo( value_to_set, 3 );
                    break;
            }
        }
        this.component_input_range.setValueFromUser( value_to_set );
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.OFF );
        if ( event || value_to_set !== null ) {
            this._computeState();
        }
    },
    ___onFocusOut               : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                if ( this.component_input_range.component_input.hasBeenChanged() ) {
                    var new_value = this.component_input_range.component_input.getValue();
                    
                    var new_value_float = SHINKEN.TOOLS.NUMBER.parseFloat( new_value );
                    if ( isNaN( new_value_float ) || new_value_float < 0 || new_value_float > 100 ) {
                        return;
                    }
                    this.component_input_range.component_input.dom_element.value = SHINKEN.TOOLS.NUMBER.roundTo( new_value_float, 3 );
                    this.component_input_range.component_input.setValue();
                    this._computeState();
                }
                break;
        }
    },
    ___clickOnRadioBtn          : function ( value ) {
        var _value_to_set;
        var _btn_status;
        switch ( value ) {
            case PROPERTY.CONST.DEFAULT_BUTTON_LABEL:
                _btn_status = this.component_btn_default.getState();
                switch ( _btn_status ) {
                    case COMPONENT.CONST.BTN_STATE.OFF:
                        this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        _value_to_set = this.default_value;
                        break;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                _btn_status = this.component_btn_no_override.getState();
                switch ( _btn_status ) {
                    case COMPONENT.CONST.BTN_STATE.OFF:
                        this.changeNoOverrideButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        _value_to_set = this.component_btn_no_override.value;
                        break;
                    case COMPONENT.CONST.BTN_STATE.ON:
                        return;
                }
                break;
        }
        this.component_input_range.setValue( _value_to_set );
        this._computeState();
    },
    changeDefaultButtonStatus   : function ( value, prevent_compute ) {
        this.component_btn_default.setState( value );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', value );
        if ( prevent_compute ) {
            return;
        }
        if ( this.component_btn_default.getState() && !(this.component_btn_inheritance.isSet() && this.component_btn_inheritance.getState()) ) {
            this.component_input_range.setValue( this.component_btn_default.getValue() );
        }
        if ( this.is_override ) {
            this.component_btn_no_override.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this._computeState();
    },
    changeNoOverrideButtonStatus: function ( value, prevent_compute ) {
        this.component_btn_no_override.setState( value );
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', COMPONENT.CONST.BTN_STATE.OFF );
        if ( prevent_compute ) {
            return;
        }
        if ( this.component_btn_no_override.getState() ) {
            this.component_input_range.setValue( this.component_btn_no_override.getValue() );
        }
        this._computeState();
    },
    clickOnBtnInheritance       : function () {
        this.setStateInheritance( !this.state_inheritance );
        this.custom_selected = this.state_inheritance ? PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE : PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
        this._computeState();
    },
    askComputeAfterChange       : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input_range.askComputeAfterChange( dom_element, this );
    },
    doActionAfterChange         : function () {
        this.component_input_range.component_input.setValue();
        if ( this.is_mass_change && this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue() === PROPERTY.CONST.MASS_CHANGE.ACTION.SET_SYNCHRO ) {
            var _value = this.component_input_range.component_input.getValue();
            this.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION.SET, null, this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
            this.setValueFromUser( _value );
        }
        if ( !this.component_input_range.component_input.getValue() && this.is_override ) {
            this.changeNoOverrideButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
        }
        else if ( !this.component_input_range.component_input.getValue() ) {
            this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.ON, true );
            var _value_to_set = this.component_btn_default.getValue();
            if ( this.state_inheritance && this.component_btn_inheritance.isSet() ) {
                _value_to_set = this.inherited_value;
            }
            this.component_input_range.setValue( _value_to_set );
        }
        else {
            if ( this.is_override ) {
                this.changeNoOverrideButtonStatus( COMPONENT.CONST.BTN_STATE.OFF, true );
            }
            else {
                this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.OFF, true );
            }
            this.component_input_range.setValueFromUser( this.component_input_range.component_input.getValue() );
        }
        this.setStateInheritance( !this.component_input_range.getValue() );
        this._computeState();
        
        if ( !this.component_input_range.component_input || !this.component_input_range.component_input.hasFocus() ) {
            MANAGER.ListenerEventManager.afterActionProperty( this );
        }
        else {
            this.do_after_action_after_loosing_focus = true;
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance    : function () {
        if ( this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE ) {
            if ( this.component_btn_inheritance.isSet() ) {
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
        else {
            if ( this.component_btn_inheritance.isSet() ) {
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
            }
        }
    },
    updateWithTemplateSpecific: function () {
        this._computeState();
        this._computeInheritedLabel();
    },
    _computeState             : function () {
        var _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        if ( this.is_override ) {
            if ( this.component_btn_no_override.isOn() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
            else if ( this.component_btn_default.isOn() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT;
            }
            else {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
            }
        }
        else if ( this.is_mass_change ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                    if ( this.component_input_range.getValue() === PROPERTY.CONST.DEFAULT_BUTTON_LABEL ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    }
                    break;
            }
        }
        else if ( this.state_inheritance && this.component_btn_inheritance.isSet() ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else {
            if ( this.component_btn_default.isOn() ) {
                if ( this.component_btn_inheritance.isSet() ) {
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                }
                else {
                    if ( this.state === PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                    }
                    else {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    }
                }
            }
        }
        this.setState( _to_set );
        this.askCheckErrorWarning();
    },
    _computeInheritedLabel    : function ( inherited_value ) {
        var _to_return;
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.RANGE:
                switch ( inherited_value ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        inherited_value = this.default_value;
                        break;
                }
                _to_return = inherited_value + this.component_input_range.unit;
                break;
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                switch ( inherited_value ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        return _( "element.business_impact_" + this.default_value );
                }
                _to_return = _( "element.business_impact_" + inherited_value );
                break;
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                switch ( inherited_value ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        inherited_value = this.default_value;
                        break;
                }
                _to_return = inherited_value + this.component_input_range.unit;
                break;
        }
        return _to_return;
    },
    //********************************************  GET / SET  **************************************************//
    ___unset         : function () {
        if ( this.is_mass_change ) {
            this.component_input_range.setValue( PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
            this.component_input_range.value_from_user = '';
            
            if ( this.component_input_range.component_label_input ) {
                this.component_input_range.component_label_input.updateLabel( _( 'mass-change.input.extra-action.NONE' ) );
            }
            this._computeState();
        }
        else {
            this.setValueFromUser( "" );
        }
    },
    setValueFromUser : function ( value ) {
        if ( !value ) {
            if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.DEFAULT_BUTTON_LABEL;
            }
        }
        switch ( value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                this.clickOnRadioBtn( null, value );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.DEFAULT_BUTTON_LABEL:
                this.clickOnRadioBtn( null, PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                if ( !this.state_inheritance ) {
                    this.clickOnBtnInheritance();
                }
                break;
            default:
                this.onMoveRangeCursor( parseFloat( value ) );
                break;
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    isDifferentValue : function ( value1, value2 ) {
        if ( value1 === value2 ) {
            return false;
        }
        return parseFloat( value1 ) !== parseFloat( value2 );
    },
    getComponents    : function () {
        return [this.component_input_range, this.component_btn_inheritance];
    },
    getFlatValue     : function () {
        var _to_return = '';
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                _to_return = this.component_btn_inheritance.isSet() ? this.getValueInherited() : this.default_value;
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                _to_return = this.default_value;
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                _to_return = this.getValue();
                break;
        }
        if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
            _to_return = this.default_value;
        }
        return _to_return;
    },
    getValueInherited: function () {
        return this.component_btn_inheritance.getValueFinal();
    },
    //********************************************  INHERITANCE **************************************************//
    setStateInheritanceSpecific: function () {
        if ( this.state_inheritance && this.component_btn_inheritance.isSet() ) {
            this.component_input_range.setValue( this.inherited_value, false );
        }
        else if ( this.component_btn_default.isOn() && !this.is_mass_change ) {
            this.component_input_range.setValue( this.component_btn_default.getValue(), false );
        }
        else if ( this.is_override && this.component_btn_no_override.isOn() ) {
            this.component_input_range.setValue( this.component_btn_no_override.getValue(), false );
        }
        else {
            this.component_input_range.setValueFromUser( this.component_input_range.getValueFromUser() );
        }
    },
    //********************************************  VALIDATION  *********************************************************//
    computeErrorsSpecifics: function () {
        if ( this.type === PROPERTY.CONST.TYPES.RANGE_WITH_INPUT ) {
            this.component_input_range.component_input.validateValueInput();
        }
    },
    setErrorsSpecific     : function () {
        var _property_associate = MANAGER.ListenerEventManager.getObjectLink( this )[ 0 ];
        this.counter_temp_error = 0;
        var _name               = this.is_override ? this.override_prop_name : this.name;
        switch ( _name ) {
            case PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD:
            case PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD:
                if ( this.is_override ) {
                    var _element = MANAGER.__instance_property_distributor.getElement( _property_associate );
                    if ( _element ) {
                        _element.checkErrorWarning();
                    }
                }
                else {
                    MANAGER.__instance_property_distributor.findElement( _property_associate ).checkErrorWarning();
                }
                return;
            case PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD:
            case PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD:
                if ( this.is_override ) {
                    var _element = MANAGER.__instance_property_distributor.getElement( _property_associate );
                    if ( !_element ) {
                        return;
                    }
                    var _high_value = this.getValueFinalOverride();
                    var _low_value  = _element.getValueFinalOverride();
                    if ( parseFloat( _high_value ) < parseFloat( _low_value ) ) {
                        this.counter_temp_error = 1;
                    }
                }
                else {
                    var _high_value = this.getFlatValue();
                    var _low_value  = MANAGER.__instance_property_distributor.findElement( _property_associate ).getFlatValue();
                    if ( parseInt( _high_value ) < parseInt( _low_value ) ) {
                        this.counter_temp_error = 1;
                    }
                }
                if ( this.counter_temp_error ) {
                    _name === PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD ? this.counter_error_tooltip = _( "element.incoherent_flapping_values" ) : this.counter_error_tooltip = _( "element.incoherent_sla_values" );
                }
                return;
        }
    },
    //********************************************  SYNCHRONIZATION **************************************************//
    synchronizeAtMinimum   : function ( property, force ) {
        if ( this.is_mass_change && !force ) {
            return this.synchronizeAtMassChange( property, false );
        }
        var _property_value = parseFloat( property._computeValueForSynchronize() );
        var _current_value  = parseFloat( this.component_input_range.getValue() );
        if ( isNaN( _current_value ) && this.is_mass_change ) {
            this.onMoveRangeCursor( _property_value, null, true );
        }
        else if ( _current_value < _property_value && _property_value >= this.component_input_range.min && _property_value <= this.component_input_range.max ) {
            this.onMoveRangeCursor( _property_value, null, true );
        }
    },
    synchronizeAtMaximum   : function ( property, force ) {
        if ( this.is_mass_change && !force ) {
            return this.synchronizeAtMassChange( property, true );
        }
        var _property_value = parseFloat( property._computeValueForSynchronize() );
        var _current_value  = parseFloat( this.component_input_range.getValue() );
        if ( isNaN( _current_value ) && this.is_mass_change ) {
            this.onMoveRangeCursor( _property_value, null, true );
        }
        else if ( _current_value > _property_value && _property_value >= this.component_input_range.min && _property_value <= this.component_input_range.max ) {
            this.onMoveRangeCursor( _property_value, null, true );
        }
    },
    synchronizeAtMassChange: function ( property, is_max ) {
        var _action_property = property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        var _action_this     = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        switch ( _action_this ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_SYNCHRO:
                switch ( _action_property ) {
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                        this.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, null, this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
                        this.stop_synchronization = true;
                        return;
                }
                break;
        }
        switch ( _action_property ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                if ( (_action_this !== PROPERTY.CONST.MASS_CHANGE.ACTION.NONE && this.state !== PROPERTY.CONST.STATE_PROPERTY.INHERITANCE) ) {
                    this.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, null, this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
                    this.stop_synchronization = true;
                }
                return;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                return;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                if ( _action_this === PROPERTY.CONST.MASS_CHANGE.ACTION.SET ) {
                    if ( property.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
                        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
                            return;
                        }
                        else {
                            return property.synchronizeAtMassChange( this, !is_max );
                        }
                    }
                    return is_max ? this.synchronizeAtMaximum( property, true ) : this.synchronizeAtMinimum( property, true );
                }
                if ( property.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
                    return;
                }
                break;
        }
        switch ( _action_this ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                return;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                this.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION.SET_SYNCHRO, null, this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
                this.stop_synchronization = true;
                break;
        }
        if ( property.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE && this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
            return;
        }
        this.onMoveRangeCursor( property.getValue(), null, true );
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal: function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : "";
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
        }
        return this.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.Range, PROPERTY.Interface );