var CONTROLLER   = CONTROLLER || {};
CONTROLLER.Apply = (function ( self ) {
    "use strict";
    self.controller_name     = MANAGER.CONST.CONTROLLER.APPLY;
    self.phase               = new SHINKEN.OBJECT.Phase();
    //********************************************  EVENT LISTENER  **************************************************//
    self.clickOnButton       = function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-option-header-popup":
            case "click-on-header-popup":
            case "click-on-header":
            case "click_on_pagination_btn":
                self.set_apply_msg.clickOnButton( event, event_name, param );
                break;
            case "click_on_apply_clean_error":
                self.slide_panel.setMinWidth( 200 );
                self.slide_panel.pinToLeft();
                set_left_column_state( __STATE_ACTION_AREA_NONE );
                MANAGER.ApplySize.reset();
                break;
            case "shinken-edition-main-panel-pin-to-right":
                self.slide_panel.pinToRight();
                this.computeSizes();
                break;
            case "shinken-edition-main-panel-pin-to-left":
                self.slide_panel.pinToLeft();
                this.computeSizes();
                break;
        }
    };
    self.clickOnInput        = function ( event ) {
        self.set_apply_msg.clickOnInput( event );
    };
    self.onChangeOnInput     = function ( event ) {
        var _key_code = event.keyCode || "";
        switch ( _key_code ) {
            case SHINKEN.CONST.KEY_CODE.ENTER:
            case SHINKEN.CONST.KEY_CODE.UP:
            case SHINKEN.CONST.KEY_CODE.DOWN:
                self.doActionAfter( "on-key-down", event );
                break;
            default:
                self.set_apply_msg.askComputeAfterChange( event.target );
                break;
        }
        self.computeSizes();
        self.slide_panel.computeSizes();
    };
    self.computeSizes        = function () {
        MANAGER.ApplySize.computeSizes();
    };
    self.onClick             = function ( event ) {
        if ( self.set_apply_msg ) {
            self.set_apply_msg.onClick( event );
        }
    };
    self.doActionAfter       = function ( event_name, param ) {
        switch ( event_name ) {
            case "ask-for-pop-up-close-event":
                break;
        }
    };
    self.clickOnSelector     = function ( event, param ) {
        self.set_apply_msg.clickOnSelector( event, param );
    };
    self.clickOnItemSelector = function ( event, parent_name, element ) {
        self.set_apply_msg.clickOnItemSelector( event, parent_name, element );
        self.computeSizes();
    };
    //********************************************  RESIZE  ******************************************//
    
    self.onResizeStart = function ( element_name ) {
    };
    self.onResizeMove  = function ( element_name, width, height ) {
    };
    self.onResizeStop  = function ( element_name ) {
    };
    //********************************************  DRAG & DROP  ******************************************//
    
    self.onDragStart           = function ( origin_x, origin_y ) {
        self.slide_panel.onDragStart( origin_x, origin_y );
    };
    self.onDragMove            = function ( element_name, width, height ) {
        self.slide_panel.onDragMove( width, height );
        self.computeSizes();
    };
    self.onDragStop            = function () {
        self.slide_panel.onDragStop();
    };
    //********************************************  INIT  **************************************************//
    self.init                  = function () {
        self.phase.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        self.slide_panel = new SHINKEN.OBJECT.SlidePanelLeftFromHtml( "apply-slide-panel", document.getElementById( "id-shinken-apply-slide-panel" ), 200, 800 );
        self.slide_panel.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        self.slide_panel.initSizePixel( 200 );
        setTimeout( function () {
            self.computeSizes();
        }, 100 );
    };
    self.initSetApplyMsg       = function ( data ) {
        self.slide_panel.setMinWidth( 450 );
        self.slide_panel.computeSizes();
        var datetime_now          = DATE_TIME.now();
        var left_panel_date       = document.getElementById( 'left-panel-error-datetime' );
        left_panel_date.innerHTML = '<span id="left-panel-error-datetime-content">' + _( 'apply.on_date' ) + ' <span class="shinken-date">' + DATE_TIME.FORMAT.get_date( datetime_now ) + '</span> ' + _( 'apply.at' ) + '   <span class="shinken-date">' + datetime_now.toLocaleTimeString( global_lang ) + '</span></span>';
        
        self.set_apply_msg = new SHINKEN_LIST.SetUIApply( "apply_message" );
        self.set_apply_msg.setHeaders( new SHINKEN_LIST.HeadersApplyMsg( "apply_message" ) );
        self.set_apply_msg.setFilters( new SHINKEN_LIST.FiltersApplyMsg( "apply_message" ) );
        self.set_apply_msg.setLines( self.set_apply_msg.computeLines( data ) );
        self.set_apply_msg.setPagination( new SHINKEN_LIST.Pagination( 100 ) );
        self.set_apply_msg.computeHtml();
        var left_panel_content = document.getElementById( 'left-panel-error-content' );
        DOM.Service.empty( left_panel_content );
        DOM.Service.addElementTo( self.set_apply_msg.getDomElement(), left_panel_content );
        
        set_left_column_state( __STATE_ACTION_AREA_CHECKING_LOG_ERROR_FULL );
        
        self.computeSizes();
        setTimeout( function () {
            self.set_apply_msg.initCountersSpecific();
        }, 10 );
    };
    //********************************************  OTHER  *****************************************************//
    self.askComputeAfterResize = function () {
        if ( self.timeout_resize ) {
            clearTimeout( self.timeout_resize );
        }
        self.timeout_resize = setTimeout( function () {
            self.timeout_resize = null;
            self.resizeDone();
        }, 100 );
    };
    self.resizeDone            = function () {
    };
    return self;
})( CONTROLLER.Apply || {} );

document.addEventListener( "click", function ( e ) {
    CONTROLLER.Apply.onClick( e );
} );
document.addEventListener( "DOMContentLoaded", function ( e ) {
    CONTROLLER.Apply.init();
} );
window.addEventListener( "resize", function () {
    CONTROLLER.Apply.computeSizes();
} );