//__lib__ lib_common
'use strict';

SHINKEN_LIST.LineCellApplyMsgId           = function ( name, data ) {
    this.name  = name;
    this.value = data[ 'id' ];
    this.init();
};
SHINKEN_LIST.LineCellApplyMsgId.prototype = {
    init: function () {
        this.setSortingValue( this.value );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    computeLabel: function () {
        this.label = '<div class="shinken-id-content">' + this.value + '</div>';
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.computeContentHtml();
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-list-cell", "data-name": this.name } ) );
        this.addDomElement( this.dom_element_content );
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function () {
        return null;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellApplyMsgId, SHINKEN_LIST.LineCellFromData );