//__lib__ lib_common
'use strict';

SHINKEN_LIST.LineCellApplyMsgStatus           = function ( name, text ) {
    this.name  = name;
    this.value = text;
    this.init();
};
SHINKEN_LIST.LineCellApplyMsgStatus.prototype = {
    init: function () {
        this.setSortingValue( this.value );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    computeLabel: function () {
        this.label = '<div class="shinken-status-content text-break-all-pre-line" data-status="' + this.value + '">' + _( 'filter.error_level.' + this.value, [DICTIONARY_COMMON_UI] ) + '</div>';
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.computeContentHtml();
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-list-cell", "data-name": this.name } ) );
        this.addDomElement( this.dom_element_content );
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function () {
        return null;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellApplyMsgStatus, SHINKEN_LIST.LineCellFromData );

SHINKEN_LIST.LineCellApplyMsgType           = function ( name, text ) {
    this.name  = name;
    this.value = text;
    this.init();
};
SHINKEN_LIST.LineCellApplyMsgType.prototype = {
    //********************************************  GETTER SETTER  *****************************************************//
    computeLabel: function () {
        if ( this.value ) {
            this.label = '<div class="shinken-status-content" data-status="' + this.value + '">' + _( 'type.' + this.value ) + '</div>';
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellApplyMsgType, SHINKEN_LIST.LineCellApplyMsgStatus );
