//__lib__ lib_common
'use strict';

SHINKEN_LIST.LineCellApplyMsgText           = function ( name, data ) {
    this.name = name;
    this.computeValues( data );
    this.init();
};
SHINKEN_LIST.LineCellApplyMsgText.prototype = {
    init: function () {
        this.setSortingValue( this.value );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    computeLabel: function () {
        this.label = '<div class="shinken-text-content">' + this.value + '</div>';
    },
    //********************************************  HTML  *****************************************************//
    computeHtml  : function () {
        this.computeContentHtml();
        this.setDomElement( DOM.Service.createElement( "td",
            {
                class: "shinken-list-cell", "data-name": this.name,
                "shi-tip-placement"                    : "top"
            } ) );
        this.addDomElement( this.dom_element_content );
    },
    computeValues: function ( data ) {
        this.value = SHINKEN.TOOLS.STRING.cleanXss( data[ this.name ] );
        switch ( data[ 'message_type' ] ) {
            case "ELEMENT" :
                this.value = data[ 'link' ] + " - " + this.value;
                break;
        }
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function () {
        return null;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellApplyMsgText, SHINKEN_LIST.LineCellFromData );
