'use strict';

SHINKEN_LIST.FilterApplyMsg           = function ( type, name ) {
    this.type = type;
    this.name = name;
    this.init();
};
SHINKEN_LIST.FilterApplyMsg.prototype = {
    init          : function () {
        this.initComponents();
    },
    initComponents: function () {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                this.component = new COMPONENT.SelectFromData( this.type );
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT:
                this.component = new COMPONENT.InputFromData( this.type );
                this.component.setPlaceholder(_( 'filter.message_placeholder' , [ DICTIONARY_COMMON_UI ]  )  );
                this.component.skipValidation( true );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FilterApplyMsg, SHINKEN_LIST.FilterFromData );
