'use strict';

SHINKEN_LIST.FiltersApplyMsg           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.FiltersApplyMsg.prototype = {
    //********************************************  INIT  **************************************************//
    init                : function () {
        this.initContents();
        var _headers = [];
        switch ( this.type ) {
            case "apply_message":
                _headers = SHINKEN_LIST.APPLY_MSG.HEADERS;
                break;
        }
        var _keys = Object.keys( _headers );
        var _current_value;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_value = _headers[ _keys[ i ] ];
            var _to_add    = new SHINKEN_LIST.FilterApplyMsg( _current_value.FILTER_TYPE, _current_value._KEY );
            if ( _current_value.FILTER_TYPE === COMPONENT.CONST.TYPE.SINGLE_SELECT ) {
                _to_add.getComponent().setOptionsFromArray( this.computeFilterOptions( _current_value ) );
            }

            this.add( _to_add );
        }
    },
    computeFilterOptions: function ( header_info ) {
        var _to_return = [];
        var _keys      = Object.keys( header_info.FILTER_OPTIONS );
        var _current_key;
        var _to_add;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key       = _keys[ i ];
            _to_add            = { "name": header_info.FILTER_OPTIONS[ _current_key ] };
            switch ( header_info._KEY) {
                case SHINKEN_LIST.APPLY_MSG.HEADERS.ERROR_LEVEL._KEY :
                    _to_add[ 'label' ] = _( 'filter.error_level.' + _to_add.name , [ DICTIONARY_COMMON_UI ]  );
                    break;
                case SHINKEN_LIST.APPLY_MSG.HEADERS.TYPE._KEY :
                    _to_add[ 'label' ] = _( 'type.' + _to_add.name );
                    break;
    
            }
            if ( i === 0 ) {
                _to_add[ 'is_selected' ] = true;
            }
            _to_return.push( _to_add );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FiltersApplyMsg, SHINKEN_LIST.FiltersFromData );

