//__lib__ lib_common
'use strict';

SHINKEN_LIST.HeaderMessageApplyMsg           = function ( type ) {
    this.type = type;
    this.initSpecific();
};
SHINKEN_LIST.HeaderMessageApplyMsg.prototype = {
    initSpecific: function () {
        this.init();
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-list-header", "data-name": this.name, "data-object-type": this.getObjectType() } ) );
        var _to_add                          = DOM.Service.createElement( "div", { class: "shinken-container" } );
        var _table                           = DOM.Service.createElement( "table", { class: "shinken-table" } );
        var _tr                              = DOM.Service.createElement( "tr" );
        var _td_1                            = DOM.Service.createElement( "td", { class: "shinken-cell-label" } );
        var _td_2                            = DOM.Service.createElement( "td", { class: "shinken-cell-filtering" } );
        var _div_1                           = DOM.Service.createElement( "div", { class: "shinken-label" }, this.label );
        this.dom_element_parent_filter       = DOM.Service.createElement( "div", { class: "shinken-filtering shinken-counter", "data-number": "" }, _( 'apply.header_filter_message' ) );
        var _div_2 = DOM.Service.createElement( "div", { class: "shinken-active-if-has-filter" }, _( 'apply.header_filter_message_after_filter' ) );
        
        DOM.Service.addElementTo( _table, _to_add );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _td_1, _tr );
        DOM.Service.addElementTo( _td_2, _tr );
        DOM.Service.addElementTo( _div_1, _td_1 );
        DOM.Service.addElementTo( this.dom_element_parent_filter, _td_2 );
        DOM.Service.addElementAtIndex( _div_2, this.dom_element_parent_filter, 0 );
        this.addDomElement( _to_add );
        
        this.dom_element_current_filter = this.getDomElement().querySelector( ".shinken-current-filter-value" );
        this.dom_element_total_filter   = this.getDomElement().querySelector( ".shinken-total-filter-value" );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeaderMessageApplyMsg, SHINKEN_LIST.HeaderFromData );