'use strict';

SHINKEN_LIST.HeadersApplyMsg           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.HeadersApplyMsg.prototype = {
    init         : function () {
        this.initContents();
        var _headers = [];
        switch ( this.type ) {
            case "apply_message":
                _headers = SHINKEN_LIST.APPLY_MSG.HEADERS;
                break;
        }
        var _keys = Object.keys( _headers );
        var _current_value;
        var _to_add;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_value = _headers[ _keys[ i ] ];
            switch ( _current_value._KEY ) {
                case SHINKEN_LIST.APPLY_MSG.HEADERS.MESSAGE._KEY:
                    _to_add       = new SHINKEN_LIST.HeaderMessageApplyMsg( this.type );
                    _to_add.name  = "message";
                    _to_add.label = "Message";
                    this.add( _to_add );
                    break;
                case SHINKEN_LIST.APPLY_MSG.HEADERS.TYPE._KEY:
                    _to_add       = new SHINKEN_LIST.HeaderFromData( this.type );
                    _to_add.name  = "type";
                    _to_add.label = "Type";
                    this.add( _to_add );
                    break;
                case SHINKEN_LIST.APPLY_MSG.HEADERS.ERROR_LEVEL._KEY:
                    _to_add       = new SHINKEN_LIST.HeaderFromData( this.type );
                    _to_add.name  = "error_level";
                    _to_add.label = "Statut";
                    this.add( _to_add );
                    break;
                case SHINKEN_LIST.APPLY_MSG.HEADERS.ID._KEY:
                    _to_add       = new SHINKEN_LIST.HeaderFromData( this.type );
                    _to_add.name  = "id";
                    _to_add.label = "Ligne";
                    this.add( _to_add );
                    break;
            }
        }
    },
    //clickOnButton: function ( event, event_name, param ) {
    //    switch ( event_name ) {
    //        case "click-on-header-popup":
    //            this.getContentByUUID( param ).clickOnButton( event, event_name, param );
    //            break;
    //        case "click-on-option-header-popup":
    //            this.clickOnOptionHeaderSorting( event, event_name, param );
    //            break;
    //        case "click-on-header":
    //            this.clickOnHeaderSorting( event, event_name, param );
    //            break;
    //    }
    //}
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeadersApplyMsg, SHINKEN_LIST.HeadersFromData );

SHINKEN_LIST.APPLY_MSG         = {};
SHINKEN_LIST.APPLY_MSG.HEADERS = {
    ID  : {
        _KEY        : "id",
        INDEX_COLUMN: 0,
        FILTER_TYPE : COMPONENT.CONST.TYPE.HIDDEN
    },
    ERROR_LEVEL: {
        _KEY          : "error_level",
        INDEX_COLUMN  : 1,
        FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
        FILTER_OPTIONS: {
            ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
            CRITICAL: "CRITICAL",
            ERROR  : "ERROR",
            WARNING: "WARNING",
            //INFO   : "INFO",
            //DEBUG  : "DEBUG"
        }
    },
    TYPE  : {
        _KEY        : "type",
        INDEX_COLUMN: 2,
        FILTER_TYPE : COMPONENT.CONST.TYPE.SINGLE_SELECT,
        FILTER_OPTIONS: {
            ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
            EMPTY    : SHINKEN_LIST.CONST.FILTER.EMPTY,
            NOT_EMPTY    : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
            CLUSTERS   : 'clusters',
            CLUSTERTPLS: 'clustertpls',
            HOSTS     : 'hosts',
            HOSTTPLS  : 'hosttpls',
            HOSTGROUPS: 'hostgroups',
            SERVICESHOSTS      : 'serviceshosts',
            SERVICESHOSTTPLS   : 'serviceshosttpls',
            SERVICESCLUSTERS   : 'servicesclusters',
            SERVICESCLUSTERTPLS: 'servicesclustertpls',
            SERVICETPLS        : 'servicetpls',
            CONTACTS     : 'contacts',
            CONTACTTPLS  : 'contacttpls',
            CONTACTGROUPS: 'contactgroups',
            ESCALATIONS              : 'escalations',
            NOTIFICATIONWAYS         : 'notificationways',
            COMMANDS                 : 'commands',
            TIMEPERIODS              : 'timeperiods',
        }
    },
    MESSAGE  : {
        _KEY        : "message",
        INDEX_COLUMN: 3,
        FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
    }
};

