'use strict';

SHINKEN_LIST.LineApplyMsg           = function ( type, data, parent ) {
    this.__class_name__ = "SHINKEN_LIST.LineApplyMsg";
    this.type           = type;
    this.init( data, parent );
};
SHINKEN_LIST.LineApplyMsg.prototype = {
    init          : function ( data, parent ) {
        this.initContents();
        this.is_filtered = false;
        this.uuid        = SHINKEN.TOOLS.STRING.buildUUID();
        this.initCellsValue( data );
        this.initPhase( this.dom_element );
    },
    initCellsValue: function ( data ) {
        var _headers = [];
        switch ( this.type ) {
            case "apply_message":
                _headers = SHINKEN_LIST.APPLY_MSG.HEADERS;
                break;
        }
        var _keys = Object.keys( _headers );
        var _current_value;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_value = _headers[ _keys[ i ] ];
            this.addWithFactory( _current_value._KEY, data );
        }
    },
    addWithFactory: function ( current_key, data ) {
        switch ( current_key ) {
            case SHINKEN_LIST.APPLY_MSG.HEADERS.ID._KEY :
                this.add( new SHINKEN_LIST.LineCellApplyMsgId( current_key, data ) );
                break;
            case SHINKEN_LIST.APPLY_MSG.HEADERS.MESSAGE._KEY :
                this.add( new SHINKEN_LIST.LineCellApplyMsgText( current_key, data ) );
                break;
            case SHINKEN_LIST.APPLY_MSG.HEADERS.TYPE._KEY :
                this.add( new SHINKEN_LIST.LineCellApplyMsgType( current_key, data[ current_key ] ) );
                break;
            case SHINKEN_LIST.APPLY_MSG.HEADERS.ERROR_LEVEL._KEY :
                this.add( new SHINKEN_LIST.LineCellApplyMsgStatus( current_key, data[ current_key ] ) );
                break;
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnButton: function ( event, event_name, param ) {
    },
    //********************************************  GETTER SETTER  *****************************************************//
    isErrorLevel      : function () {
        return this.getContent( SHINKEN_LIST.APPLY_MSG.HEADERS.ERROR_LEVEL.INDEX_COLUMN ).getValue() !== SHINKEN_LIST.APPLY_MSG.HEADERS.ERROR_LEVEL.FILTER_OPTIONS.WARNING;
    },
    initFilterCounter: function (parent) {
        this.initCounter( SHINKEN.OBJECT.CounterV2_CONST.TYPE.FILTERING );
    
        this.setCounterParent( parent, SHINKEN.OBJECT.CounterV2_CONST.TYPE.FILTERING );
    },
    //********************************************  OTHERS  *****************************************************//
    doActionAfterFilterChange: function () {
        this.setCounterValue( SHINKEN.OBJECT.CounterV2_CONST.TYPE.FILTERING, this.uuid, this.is_filtered ? 0 : 1 );
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        var _selector_css_for_tooltip = '.shinken-list-cell[data-name="name"]';
        this.dom_element              = DOM.Service.createElement( "tr", {
            class      : "shinken-list-line",
            "data-uuid": this.uuid
        } );
        this.setPhaseDomElement( this.dom_element );
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            this.addDomElement( this.getContent( i ).getDomElement() );
        }
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave               : function () {
        var _to_return = {
            "type"   : SHINKEN.UI.VIEW.TYPE.WEATHER,
            "uuid"   : this.uuid,
            "actions": []
        };
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.TO_BE_DELETED ) ) {
            _to_return.actions.push( { "key": SHINKEN_LIST.CONST.ACTION.REMOVE } );
            return _to_return;
        }
        
        var _data;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _data = this.getContent( i ).getDataToSave();
            if ( _data ) {
                _to_return.actions.push( _data );
            }
        }
        if ( !_to_return.actions.length ) {
            return null;
        }
        return _to_return;
    },
    parseToFindCellUuid         : function ( key ) {
        switch ( key ) {
            case SHINKEN.UI.VIEW.ACTIONS.CHANGE_OWNER :
                return SHINKEN.UI.VIEW.HEADERS.WEATHER.CURRENT_OWNER._KEY;
            case SHINKEN.UI.VIEW.ACTIONS.REMOVE :
                return SHINKEN.UI.VIEW.HEADERS.WEATHER.ACTION._KEY;
        }
        return key;
    },
    extraActionAfterActionDoneOK: function ( action ) {
        if ( action.key === SHINKEN.UI.VIEW.ACTIONS.CHANGE_OWNER ) {
            this.getContentByUUID( SHINKEN.UI.VIEW.HEADERS.WEATHER.PREVIOUS_OWNER._KEY ).updateAfterActionDoneOK( action );
            this.getContentByUUID( SHINKEN.UI.VIEW.HEADERS.WEATHER.CURRENT_OWNER._KEY ).addExtraInformation( SHINKEN.UI.VIEW.HEADERS.WEATHER.PREVIOUS_OWNER._KEY, this.getContentByUUID( SHINKEN.UI.VIEW.HEADERS.WEATHER.PREVIOUS_OWNER._KEY ).user );
        }
    },
    extraActionAfterDone        : function ( data ) {
        this.getContentByUUID( SHINKEN.UI.VIEW.HEADERS.WEATHER.PROBLEMS._KEY ).updateAfterActionDone( data );
    },
    //********************************************  OTHER  *****************************************************//
    callbackForPhase      : function () {
        var _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.TO_BE_DELETED:
                this.setUserSet( "ask_for_delete_view", 1 );
                DOM.Service.addAttribute( this.getContentByUUID( SHINKEN.UI.VIEW.HEADERS.WEATHER.NAME._KEY ).getDomElement(), "shi-tip-html", _( "views.manager.service_weather.lines.tooltip_remove" ) );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.setUserSet( "ask_for_delete_view", 0 );
                DOM.Service.addAttribute( this.getContentByUUID( SHINKEN.UI.VIEW.HEADERS.WEATHER.NAME._KEY ).getDomElement(), "shi-tip-html", "" );
                break;
        }
    },
    cancelUserModification: function () {
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).cancelUserModification();
        }
    },
    remove                : function () {
        if ( this.dom_element ) {
            DOM.Service.removeElement( this.dom_element );
        }
        this.getContentByUUID( SHINKEN.UI.VIEW.HEADERS.WEATHER.PROBLEMS._KEY ).resetCounters();
        this.resetCounters();
    },
    getFilterStatusForInputString(_value_filter, _value_cell, _filter) {
        if ( !SHINKEN.TOOLS.STRING_FILTER.containsIgnoreCase( _value_cell + "", _value_filter ) ) {
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
        }
        return _filter;
    }

};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineApplyMsg, SHINKEN_LIST.LineFromData );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineApplyMsg, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineApplyMsg, SHINKEN.OBJECT.CounterInterfaceV2 );
