'use strict';
SHINKEN_LIST.LinesApplyMsg           = function ( type, parent ) {
    this.__class_name__ = "SHINKEN_LIST.LinesApplyMsg";
    this.type           = type;
    this.init( parent );
};
SHINKEN_LIST.LinesApplyMsg.prototype = {
    init: function ( parent ) {
        this.initContents();
        this.initPhase();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnButton: function ( event, event_name, param ) {
        switch ( event_name ) {
        }
    },
    //********************************************  OTHERS  *****************************************************//
    linkHeaderWithData: function ( headers ) {
    },
    //********************************************  COUNTERS  *****************************************************//
    initCountersSpecific: function ( parent ) {
        this.initCounter( SHINKEN.OBJECT.CounterV2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.CounterV2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.CounterV2_CONST.TYPE.TOTAL );
        this.initCounter( SHINKEN.OBJECT.CounterV2_CONST.TYPE.FILTERING );
        
        this.setCountersParent( parent );
        
        var _counter_error   = 0;
        var _counter_warning = 0;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).isErrorLevel() ? _counter_error++ : _counter_warning++;
        }
        this.setCounterValue( SHINKEN.OBJECT.CounterV2_CONST.TYPE.ERRORS, this.__class_name__, _counter_error );
        this.setCounterValue( SHINKEN.OBJECT.CounterV2_CONST.TYPE.WARNINGS, this.__class_name__, _counter_warning );
        this.setCounterValue( SHINKEN.OBJECT.CounterV2_CONST.TYPE.TOTAL, this.__class_name__, _counter_warning + _counter_error );
    },
    initFilterCounter   : function ( parent ) {
        this.initCounter( SHINKEN.OBJECT.CounterV2_CONST.TYPE.FILTERING );
        
        this.setCounterParent( parent, SHINKEN.OBJECT.CounterV2_CONST.TYPE.FILTERING );
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).initFilterCounter( this );
        }
    },
    //********************************************  HTML  *****************************************************//
    computeMessageNoContentHml: function () {
        var tr    = DOM.Service.createElement( "tr" );
        var cell  = DOM.Service.createElement( "td" );
        var div   = DOM.Service.createElement( "div", { class: "shinken-absolute-container shinken-list-no-lines" } );
        var div_2 = DOM.Service.createElement( "div", { class: "shinken-ultra-centred-text" }, _( 'apply.filter_found_no_problem' ) );
        DOM.Service.addElementTo( cell, tr );
        DOM.Service.addElementTo( div, cell );
        DOM.Service.addElementTo( div_2, div );
        this.addDomElement( tr );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesApplyMsg, SHINKEN_LIST.LinesFromDataWithPagination );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesApplyMsg, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesApplyMsg, SHINKEN.OBJECT.PhaseInterface );
