"use strict";

SHINKEN_LIST.SetUIApply           = function ( type ) {
    this.__class_name__ = "SHINKEN_LIST.SetUIApply";
    this.type           = type;
    this.initSpecific();
};
SHINKEN_LIST.SetUIApply.prototype = {
    initSpecific: function () {
        this.init();
        this.initPhase();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionBefore      : function ( event_name, param ) {
        switch ( event_name ) {
            case "apply_filter":
                DOM.Service.addOrRemoveClasses(this.getDomElement(), !!param.length, "shinken-has-filter-active" );
                this.initFilterCounter();
            break;
        }
    },
    clickOnButton: function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-open-view-external-urls-popup":
            case "click-on-open-change-view-owner-popup":
                this.onClick( event );
            case "copy_external_link":
            case "open_external_link":
            case "click-on-confirm-change-popup":
                this.lines.clickOnButton( event, event_name, param );
                break;
            case "delete-view":
            case "restore_button":
                this.onClick();
                this.lines.clickOnButton( event, event_name, param );
                break;
            case "click-on-header-popup":
                this.onClick( event );
                this.headers.clickOnButton( event, event_name, param );
                break;
            case "click-on-option-header-popup":
            case "click-on-header":
                this.hidePopup();
                this.headers.clickOnButton( event, event_name, param );
                this.doActionAfterChange( { "type": "shinken-list-sorting" } );
                break;
            case "click_on_pagination_btn":
                this.pagination.doActionAfter( event_name, param );
                this.computeLinesHtml();
                break;
        }
    },
    //********************************************  HEADERS  *****************************************************//
    computeLines: function ( data ) {
        var _to_return = new SHINKEN_LIST.LinesApplyMsg( this.type, this );
        var _to_add;
        var _current_key;
        
        for ( var i = 0, _size = data.length; i < _size; i++ ) {
            _current_key = Object.keys( data[ i ] )[ 0 ];
            _to_add      = new SHINKEN_LIST.LineApplyMsg( this.type, data[ i ], _to_return );
            _to_return.add( _to_add );
            _to_add.setIndexOriginal( i );
        }
        
        return _to_return;
    },
    //********************************************  COUNTERS  *****************************************************//
    initCountersSpecific: function () {
        this.initCounter(SHINKEN.OBJECT.CounterV2_CONST.TYPE.ERRORS);
        this.initCounter(SHINKEN.OBJECT.CounterV2_CONST.TYPE.WARNINGS);
        this.initCounter(SHINKEN.OBJECT.CounterV2_CONST.TYPE.TOTAL);
        var _header_message = this.headers.getContentByUUID( "message" );
        this.getCounter(SHINKEN.OBJECT.CounterV2_CONST.TYPE.TOTAL).setDomElement( _header_message.dom_element_total_filter );
        this.getCounter(SHINKEN.OBJECT.CounterV2_CONST.TYPE.TOTAL).setDomElementLabel( _header_message.dom_element_total_filter );
        this.getCounter(SHINKEN.OBJECT.CounterV2_CONST.TYPE.TOTAL).addTargetsDomElement( _header_message.dom_element_parent_filter );
        
        this.getCounter(SHINKEN.OBJECT.CounterV2_CONST.TYPE.ERRORS).setDomElement( document.getElementById( "id-shinken-set-apply-msg-error" ) );
        
        this.getCounter(SHINKEN.OBJECT.CounterV2_CONST.TYPE.WARNINGS).setDomElement( document.getElementById( "id-shinken-set-apply-msg-warning" ) );
        this.lines.initCountersSpecific( this );
    },
    initFilterCounter: function () {
        if ( this.getCounter(SHINKEN.OBJECT.CounterV2_CONST.TYPE.FILTERING)){
            return;
        }
        var _header_message = this.headers.getContentByUUID( "message" );
        this.initCounter(SHINKEN.OBJECT.CounterV2_CONST.TYPE.FILTERING);
        this.getCounter(SHINKEN.OBJECT.CounterV2_CONST.TYPE.FILTERING).setShowIfNull( true );
        this.getCounter(SHINKEN.OBJECT.CounterV2_CONST.TYPE.FILTERING).setDomElementLabel( _header_message.dom_element_current_filter );
        this.lines.initFilterCounter( this );
    },
    //********************************************  HTML  *****************************************************//
    doActionAfterSetDomElement: function () {
        this.lines.linkHeaderWithData( this.headers );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetUIApply, SHINKEN_LIST.SetFromDataWithPagination );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetUIApply, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetUIApply, SHINKEN.OBJECT.PhaseInterface );
