%import difflib
%from shinken.synchronizer.dao.def_items import DEF_ITEMS, ITEM_TYPE
%from shinken.synchronizer.dao.helpers import get_name_from_type
%from shinkensolutions.toolbox.box_tools_string import ToolsBoxString
%from shinken.synchronizer.plugins.apply.apply import filter_diffs

%if 'configuration_stats' not in locals():
%    from shinken.synchronizer.business.sync_ui_common import syncuicommon
%    configuration_stats = syncuicommon.get_configuration_stats(user)
%end
%include( "__shinken-lib", type="APPLY")
%rebase( "layout_skonf", title=app._('apply.title'))

%proposed_stats = configuration_stats['overall']['proposed'][1]

<script>
	var __shinken_lang__ = "{{app.lang}}";
	var global_lang = '{{app.lang}}';
	//var __shinken_element_list = {};
	var g_nb_elements = {};
	var hasChange = false;
	%parts = ['new', 'changed', 'removed']
	         %APP_DATA_KEYS = DEF_ITEMS.keys()

	                          %for p in parts:
	g_nb_elements['{{p}}'] = {};
	%for t in APP_DATA_KEYS:
	g_nb_elements['{{p}}']['{{t}}'] = {{len(filter_diffs(diffs[t][p])) if p == 'changed' else len(diffs[t][p])}};
	%end
	 %end
</script>
<div id="id-shinken-apply-slide-panel" class="shinken-slide-panel-content-all shinken-parent-event-listener shinken-height-100" data-type="HORIZONTAL_LEFT" data-controller="apply">
	<table class="shinken-table ">
		<tr>
			<td class="shinken-slide-panel-table-cell-content shinken-vertical-align-top">
				%include apply_left_panel
			</td>
			<td class="shinken-slide-panel-table-cell-buttons">
				%include apply_separator
			</td>
			<td class="shinken-main-part-cell shinken-vertical-align-top">
				%include apply_right_panel
			</td>
		</tr>
	</table>
</div>




<script>
    $( function() {
        $( '.show-objs' ).on( 'show', function( e ) {
            update_layout();
        } );
    } );
</script>
%path_common = '/static/%s/common_ui' % app.http_start_time
<link rel="stylesheet" type="text/css" href="{{path_common}}/css/_lib/shinken_common.css">
<link rel="stylesheet" type="text/css" href="/static/{{app.http_start_time}}/apply/css/apply-common.css">
<link rel="stylesheet" type="text/css" href="/static/{{app.http_start_time}}/apply/css/list/apply-msg-list-cell.css">
<link rel="stylesheet" type="text/css" href="/static/{{app.http_start_time}}/apply/css/list/apply-msg-list-filter.css">
<link rel="stylesheet" type="text/css" href="/static/{{app.http_start_time}}/apply/css/list/apply-msg-list-header.css">
<link rel="stylesheet" type="text/css" href="/static/{{app.http_start_time}}/apply/css/list/apply-msg-list.css">
<link rel="stylesheet" type="text/css" href="{{path_common}}/css/shinken/object/shinken-list.css">
<link rel="stylesheet" type="text/css" href="{{path_common}}/css/shinken/object/slide-panel.css">
<link rel="stylesheet" type="text/css" href="/static/{{app.http_start_time}}/css/shinken2023.css">


<script src="{{path_common}}/js/shinken/service/date-time.js"></script>

<script src="{{path_common}}/js/shinken/__constante.js"></script>
<script src="{{path_common}}/js/shinken/component/__constante.js"></script>
<script src="{{path_common}}/js/shinken/list/__constante.js"></script>
<script src="{{path_common}}/js/shinken/manager/__constante.js"></script>

<script src="{{path_common}}/js/shinken/object/shinken-object-interface.js"></script>
<script src="{{path_common}}/js/shinken/object/counter-V2.js"></script>


<script src="{{path_common}}/js/shinken/object/sorting.js"></script>

<script src="{{path_common}}/js/shinken/object/phase.js"></script>



<script src="{{path_common}}/js/shinken/list/shinken-list-line.js"></script>
<script src="{{path_common}}/js/shinken/list/shinken-list-lines.js"></script>
<script src="{{path_common}}/js/shinken/list/shinken-list-set.js"></script>
<script src="{{path_common}}/js/shinken/list/shinken-list-line-cell.js"></script>
<script src="{{path_common}}/js/shinken/list/shinken-list-filter.js"></script>
<script src="{{path_common}}/js/shinken/list/shinken-list-filters.js"></script>
<script src="{{path_common}}/js/shinken/list/shinken-list-header.js"></script>
<script src="{{path_common}}/js/shinken/list/shinken-list-headers.js"></script>

<script src="{{path_common}}/js/shinken/list/pagination/shinken-list-pagination.js"></script>
<script src="{{path_common}}/js/shinken/list/pagination/shinken-list-pagination-selector.js"></script>
<script src="{{path_common}}/js/shinken/list/pagination/shinken-list-pagination-navigation.js"></script>



<script src="{{path_common}}/js/shinken/list/from_data/shinken-list-line-cell-from-data.js"></script>
<script src="{{path_common}}/js/shinken/list/from_data/shinken-list-line-from-data.js"></script>
<script src="{{path_common}}/js/shinken/list/from_data/shinken-list-lines-from-data.js"></script>
<script src="{{path_common}}/js/shinken/list/from_data/shinken-list-header-from-data.js"></script>
<script src="{{path_common}}/js/shinken/list/from_data/shinken-list-headers-from-data.js"></script>
<script src="{{path_common}}/js/shinken/list/from_data/shinken-list-header-with-sort-from-data.js"></script>
<script src="{{path_common}}/js/shinken/list/from_data/shinken-list-headers-with-sort-from-data.js"></script>
<script src="{{path_common}}/js/shinken/list/from_data/shinken-list-filter-from-data.js"></script>
<script src="{{path_common}}/js/shinken/list/from_data/shinken-list-set-from-data.js"></script>
<script src="{{path_common}}/js/shinken/list/from_data/shinken-list-filters-from-data.js"></script>

<script src="{{path_common}}/js/shinken/list/from_data_with_pagination/shinken-list-pagination-from-data.js"></script>
<script src="{{path_common}}/js/shinken/list/from_data_with_pagination/shinken-list-set-from-data-with-pagination.js"></script>
<script src="{{path_common}}/js/shinken/list/from_data_with_pagination/shinken-list-lines-from-data-with-pagination.js"></script>

<script src="{{path_common}}/js/shinken/component/_interface_component.js"></script>
<script src="{{path_common}}/js/shinken/component/input.js"></script>
<script src="{{path_common}}/js/shinken/component/input-with-dropdown.js"></script>
<script src="{{path_common}}/js/shinken/component/multi-select-comp.js"></script>
<script src="{{path_common}}/js/shinken/component/single-select-comp.js"></script>
<script src="{{path_common}}/js/shinken/component/list-select-element.js"></script>
<script src="{{path_common}}/js/shinken/component/list-select-element_V2.js"></script>
<script src="{{path_common}}/js/shinken/component/list-select.js"></script>
<script src="{{path_common}}/js/shinken/component/list-select_V2.js"></script>
<script src="{{path_common}}/js/shinken/object/element-list.js"></script>

<script src="{{path_common}}/js/shinken/manager/__constante.js"></script>


<script src="{{path_common}}/js/shinken/manager/distributor-controller-manager.js"></script>

<script src="{{path_common}}/js/shinken/translation/fr.js"></script>
<script src="{{path_common}}/js/shinken/translation/en.js"></script>
<script src="{{path_common}}/js/shinken/translation/translate.js"></script>
<script src="{{path_common}}/js/shinken/manager/event-manager.js"></script>
<script src="{{path_common}}/js/shinken/manager/drag-n-drop-manager.js"></script>
<script src="{{path_common}}/js/shinken/manager/resize-manager.js"></script>

<script src="{{path_common}}/js/shinken/service/dom/dom-service.js"></script>
<script src="{{path_common}}/js/shinken/service/string-service.js"></script>
<script src="{{path_common}}/js/shinken/service/array-service.js"></script>

<script src="/static/{{app.http_start_time}}/apply/js/list/shinken-list-headers-apply-msg.js"></script>
<script src="/static/{{app.http_start_time}}/apply/js/list/shinken-list-header-message-apply-msg.js"></script>
<script src="/static/{{app.http_start_time}}/apply/js/list/shinken-list-set-apply-msg.js"></script>
<script src="/static/{{app.http_start_time}}/apply/js/list/shinken-list-filter-apply-msg.js"></script>
<script src="/static/{{app.http_start_time}}/apply/js/list/shinken-list-filters-apply-msg.js"></script>
<script src="/static/{{app.http_start_time}}/apply/js/list/shinken-list-line-apply-msg.js"></script>
<script src="/static/{{app.http_start_time}}/apply/js/list/shinken-list-lines-apply-msg.js"></script>
<script src="/static/{{app.http_start_time}}/apply/js/cell_format/shinken-list-line-cell-text.js"></script>
<script src="/static/{{app.http_start_time}}/apply/js/cell_format/shinken-list-line-cell-status.js"></script>
<script src="/static/{{app.http_start_time}}/apply/js/cell_format/shinken-list-line-cell-id.js"></script>


<script src="{{path_common}}/js/shinken/object/slide-panel/slide-panel-interface.js"></script>
<script src="{{path_common}}/js/shinken/object/slide-panel/slide-panel-horizontal.js"></script>

<script src="/static/{{app.http_start_time}}/apply/js/apply-controller.js"></script>

<script src="/static/{{app.http_start_time}}/apply/js/apply-resize-manager.js"></script>