SHINKEN.TOOLS.TEST_AUTO_PROPERTY = (function ( self ) {
    self.DOM                                   = {};
    self.TEST                                  = {};
    self.TEST.JS                               = {};
    self.ACTION                                = {};
    self.GETTER                                = {};
    self.CONST                                 = {
        UNDER_SELECTOR: {
            SELECTOR      : "shinken-select-selector",
            SELECTOR_TITLE: "shinken-multiselect-title",
            SELECTOR_LABEL: "shinken-selector-label",
            LIST_SELECT   : "shinken-list-select",
            FILTER_INPUT  : "shinken-input-search"
        }
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.line                              = function ( property_name, dom_element ) {
        if ( !dom_element ) {
            dom_element = document;
        }
        return dom_element.querySelector( '.shinken-element-property-line[data-name="' + property_name + '"]' );
    };
    self.DOM.counterError                      = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-property-label .shinken-counter.shinken-error-counter' );
    };
    self.DOM.counterWarning                    = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-property-label .shinken-counter.shinken-warning-counter' );
    };
    self.DOM.lock                              = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-lock-cell' );
    };
    self.DOM.radioBtnContainer                 = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-radio-list-container' );
    };
    self.DOM.defaultButton                     = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-range-btn-default-container .shinken-radio-btn' );
    };
    self.DOM.noOverrideButton                     = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-no-override-btn' );
    };
    self.DOM.inheritanceButton                 = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-prop-cell-template .switch-button-wrapper' );
    };
    self.DOM.inheritanceButtonValue            = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-prop-cell-template .shinken-heritance-value' );
    };
    self.DOM.rangeInput                        = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-range-container input' );
    };
    self.DOM.radioButtons                      = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-btn-radio-container' );
    };
    self.DOM.selector                          = function ( property_name, selector_name, under_type ) {
        var _to_return = self.DOM.line( property_name ).querySelector( '.shinken-select-container[data-name="' + selector_name + '"]' );
        if ( under_type ) {
            _to_return = _to_return.querySelector( "." + under_type );
        }
        return _to_return;
    };
    self.DOM.option                            = function ( property_name, selector_name, option_name ) {
        var _to_return = self.DOM.line( property_name ).querySelector( '.shinken-select-container[data-name="' + selector_name + '"]' );
        return SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR.DOM.option( _to_return, option_name );
    };
    self.DOM.linkButton                        = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-link-icon-container' );
    };
    self.DOM.tagInformation                    = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-information-tag' );
    };
    self.DOM.flatCheckValue                    = function ( property_override_name ) {
        return self.DOM.line( property_override_name ).querySelector( '.shinken-flat-check-value' );
    };
    self.DOM.extraLabelPropertyName            = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-property-label .shinken-extra-label' );
    };
    //********************************************  ACTION VIA JS OBJECT   **************************************************//
    self.ACTION.selectOptionInPropertySelector = function ( timeout, property_name, selector_name, option_name ) {
        setTimeout( function () {
            var _prop = MANAGER.__instance_property_distributor.getElement( property_name );
            if ( _prop.selectors[ selector_name ] && DOM.Service.isVisible( _prop.selectors[ selector_name ].dom_element, 20 ) ) {
                _prop.clickOnItemSelector( option_name, null, _prop.selectors[ selector_name ] );
            }
        }, timeout );
        return 1000;
    };
    self.ACTION.clickOnInheritanceButton       = function ( timeout, property_name ) {
        setTimeout( function () {
            self.DOM.inheritanceButton( property_name ).click();
        }, timeout );
        return 1000;
    };
    self.ACTION.setValue                       = function ( timeout, property_name, value ) {
        var _to_return = property_name === PROPERTY.CONST.NAME.USE ? 2500 : 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'setValue', property_name + " --> " + value );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            MANAGER.__instance_property_distributor.getElement( property_name ).setValueFromUser( value );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return property_name === PROPERTY.CONST.NAME.USE ? 2500 : PROPERTY.CONST.NAME.ADDRESS ? 2500 : 1000;
    };
    self.ACTION.clickOnDefaultButton           = function ( timeout, property_name ) {
        setTimeout( function () {
            self.DOM.defaultButton( property_name ).click();
        }, timeout );
        return 500;
    };
    self.ACTION.clickOnNoOverrideButton           = function ( timeout, property_name ) {
        setTimeout( function () {
            self.DOM.noOverrideButton( property_name ).click();
        }, timeout );
        return 500;
    };
    self.ACTION.clickOnRadioButton             = function ( timeout, property_name, button_name ) {
        setTimeout( function () {
            self.DOM.radioBtnContainer( property_name ).querySelector( '.shinken-button[value="' + button_name + '"]' ).click();
        }, timeout );
        return 500;
    };
    self.ACTION.setValueWithSynchro            = function ( timeout, property_name, value ) {
        self.ACTION.setValue( timeout, property_name, value );
        return 4000;
    };
    //********************************************  GETTER   **************************************************//
    self.GETTER.saveValue                      = function ( property_name ) {
        return MANAGER.__instance_property_distributor.getElement( property_name ).getDataToSave();
    };
    //********************************************  TEST   **************************************************//
    self.TEST.display_                         = function ( timeout, property_name, state ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY.TEST.display_', property_name + " --> " + state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.line( property_name );
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, property_name );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom, property_name );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.EMPTY:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom, DOM.CONST.STYLE.HEIGHT, 0, property_name );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.JS.defaultValue                  = function ( timeout, property_name, value_to_test ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( MANAGER.__instance_property_distributor.elements[ property_name ].default_value, value_to_test, "defaultValue " + property_name );
        }, timeout );
        return 50;
    };
    self.TEST.hasValue                         = function ( timeout, property_name, value_expected ) {
        setTimeout( function () {
            var _value = MANAGER.__instance_property_distributor.getElement( property_name ).getValue();
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _value, value_expected, "hasValue" );
        }, timeout );
        return 50;
    };
    self.TEST.inheritanceButtonValueLabel      = function ( timeout, property_name, text_expected ) {
        setTimeout( function () {
            var _dom = self.DOM.inheritanceButtonValue( property_name );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _dom.innerText, text_expected, "validMainInputContentDisplay" );
        }, timeout );
        return 50;
    };
    self.TEST.checkValueFlatCheckValue         = function ( timeout, property_name, text_expected ) {
        setTimeout( function () {
            var _dom = self.DOM.flatCheckValue( property_name );
            SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, _dom, text_expected, "checkValueFlatCheckValue" );
        }, timeout );
        return 50;
    };
    self.TEST.counter                          = function ( timeout, property_name, error_expected, warning_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, self.DOM.counterError( property_name ), error_expected, 'error for ' + property_name );
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, self.DOM.counterWarning( property_name ), warning_expected, 'warning for ' + property_name );
        }, timeout );
        return 100;
    };
    self.TEST.countProperty                    = function ( timeout, number_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( Object.keys( MANAGER.__instance_property_distributor.elements ), number_expected, 'MANAGER.__instance_property_distributor.elements' );
        }, timeout );
        return 100;
    };
    self.TEST.countWindow                      = function ( timeout, number_expected ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.ALPHA ){
            return 0
        }
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( Object.keys( MANAGER.__instance_window_distributor.parent_windows[ MANAGER.__instance_element_distributor.current_element.uuid ].list ), number_expected, 'MANAGER.__instance_window_distributor.parent_windows[' + MANAGER.__instance_element_distributor.current_element.uuid + '].list' );
        }, timeout );
        return 100;
    };
    self.TEST.countPropertySet                 = function ( timeout, number_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( Object.keys( getCurrentObjectFromProperty() ), number_expected, 'getCurrentObjectFromProperty' );
        }, timeout );
        return 100;
    };
    self.TEST.radioButton                      = function ( dom_element, state, inner_text ) {
        var _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE;
        switch ( state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                if ( dom_element.getAttribute( "value" ) === PROPERTY.CONST.BUTTON_LABEL.INHERITANCE ) {
                    _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE_INHERITED;
                }
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                if ( dom_element.getAttribute( "value" ) === PROPERTY.CONST.BUTTON_LABEL.USER_SET ) {
                    _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE;
                }
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET_NONE:
                if ( dom_element.getAttribute( "value" ) === PROPERTY.CONST.BUTTON_LABEL.NULL ) {
                    _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE;
                }
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                if ( dom_element.getAttribute( "value" ) === PROPERTY.CONST.BUTTON_LABEL.DEFAULT ) {
                    _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE;
                }
                break;
        }
        switch ( _to_test ) {
            case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "backgroundColor", "rgb(217, 217, 217)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "color", "rgb(51, 51, 51)" );
                break;
            case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE_INHERITED:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "backgroundColor", "rgba(128, 0, 128, 0.65)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, 'shinken-active' );
                break;
            case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, 'shinken-active' );
                break;
        }
        SHINKEN.TOOLS.TEST_AUTO.__isVisibleAndHasInnerText( dom_element, inner_text );
    };
    self.TEST.tagInformationDisplay            = function ( timeout, property_name, state ) {
        setTimeout( function () {
            var _dom_tag_info = self.DOM.tagInformation( property_name );
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_tag_info, "tag information for <span class='shinken-data-user'>" + property_name + "</span>" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_tag_info, "tag information for <span class='shinken-data-user'>" + property_name + "</span>" );
                    break;
            }
        }, timeout );
        return 10;
    };
    self.TEST.linkButton                       = function ( timeout, property_name, state, uuid_link ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return 0
        }
        setTimeout( function () {
            var _dom_link_button = self.DOM.linkButton( property_name );
            var _dom_link        = _dom_link_button.querySelector( ".shinken-link" );
            var _dom_icon        = _dom_link_button.querySelector( ".shinken-link-icon-button" );
            
            var _test_desc = "link button";
            var _is_visble = true;
            var _uuid_link = uuid_link || "";
            var _color     = "rgb(0, 0, 0)";
            
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.HIDDEN:
                    _is_visble = false;
                    break;
                
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.USER_SET:
                    break;
                
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.USER_SET_NEW:
                    _uuid_link = _uuid_link + '?new=1';
                    break;
                
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.INHERITED:
                    _color = "rgb(128, 0, 128)";
                    break;
                
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.INHERITED_NEW:
                    _color     = "rgb(128, 0, 128)";
                    _uuid_link = _uuid_link + '?new=1';
                    break;
            }
            if ( !_is_visble && _uuid_link ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Link button are not visible but he have a link" );
            }
            if ( _is_visble ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_icon, 'color', _color );
                SHINKEN.TOOLS.TEST_AUTO.__containsText( _dom_link.href, _uuid_link, _test_desc );
            }
            SHINKEN.TOOLS.TEST_AUTO_DOM.visibility( 0, _dom_link_button, _test_desc, _is_visble );
            
            
            
        }, timeout );
        return 10;
    };
    self.TEST.isDisabled                       = function ( timeout, property_name, extra_label ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasClass( timeout, self.DOM.line( property_name ), 'shinken-disabled', false, extra_label );
        }, timeout );
        return 500;
    };
    self.TEST.isLockDisplayed                  = function ( property_name, show, timeout ) {
        setTimeout( function () {
            if ( show ) {
                SHINKEN.TOOLS.TEST_AUTO.__isVisible( self.DOM.lock( property_name ) );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self.DOM.lock( property_name ) );
            }
        }, timeout );
        return 500;
    };
    self.TEST.isState                          = function ( timeout, property_name, state ) {
        var _to_return = 10;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY.isState', property_name + " --> " + state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            switch ( state ) {
                case PROPERTY.CONST.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self.DOM.line( property_name ) );
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.DOM.line( property_name ).dataset, 'state', state, '[--1--]' );
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( MANAGER.__instance_property_distributor.getElement( property_name ), 'state', state, '[--2--]' );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return 10;
    };
    self.TEST.isLabelDefaultButton             = function ( timeout, property_name, inner_text ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.defaultButton( property_name ), inner_text, property_name );
        }, timeout );
        return 10;
    };
    self.TEST.hasStyleDefaultButton            = function ( timeout, property_name, key, value ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.defaultButton( property_name ), key, value );
        }, timeout );
        return 10;
    };
    self.TEST.extraLabelPropertyName           = function ( timeout, property_name ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.extraLabelPropertyName(property_name), _("extra_label." + property_name), "PROPERTY EXTRA_LABEL" );
        }, timeout );
        return 10;
    };
    //********************************************  ACTION   **************************************************//
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_PROPERTY || {} );

SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST = {
    ACTION_SELECTOR_USER_SET: "rgba(30, 30, 30, 0.8)",
    STATE                   : {
        HIDDEN      : 0,
        VISIBLE     : 1,
        EMPTY       : 2,
        COLLAPSED   : 3,
        UN_COLLAPSED: 4
    },
    STATE_BUTTON            : {
        HIDDEN          : 0,
        VISIBLE         : 1,
        ACTIVE          : 2,
        ACTIVE_INHERITED: 3,
        DISABLED        : 4
    },
    STATE_LINK_BUTTON       : {
        HIDDEN       : 0,
        USER_SET     : 1,
        USER_SET_NEW : 2,
        INHERITED    : 3,
        INHERITED_NEW: 4
    }
};