SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE = (function ( self ) {
    self.ACTION   = {};
    self.TEST     = {};
    self.COMMON   = {};
    var _INTERNAL = {};
    
    //********************************************  INTERNAL   **************************************************//
    _INTERNAL.dropAllDatabases               = function () {
        self.ACTION.dropDatabase( 0, "shinken" );
        self.ACTION.dropDatabase( 0, "synchronizer" );
        self.ACTION.dropDatabase( 0, "event_container" );
        self.ACTION.dropDatabase( 0, "webui" );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.resetTime                    = function ( timeout ) {
        var _command = 'service ntpd restart';
        
        var _success = function ( _status, data ) {
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.replaceInFile                = function ( timeout, original_text, new_text, file ) {
        var _command = "sed -i 's/" + original_text + "/" + new_text + "/g' " + file;
        
        var _success = function ( _status, data ) {
            if ( data.rc !== 0 ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Error while replacing [ " + data.stdout + " ]" );
            }
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 500;
    };
    self.ACTION.createFileAndSetShinkenOwner = function ( timeout, file, to_write ) {
        var _command = "sudo -u shinken echo " + to_write + " >> " + file;
        
        var _success = function ( _status, data ) {
            if ( data.rc !== 0 ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Error while creating [ " + data.stdout + " ]" );
            }
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 500;
    };
    self.ACTION.removeFile                   = function ( timeout, file ) {
        var _command = "rm " + file;
        
        var _success = function ( _status, data ) {
            if ( data.rc !== 0 ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Error while deleting [ " + data.stdout + " ]" );
            }
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 500;
    };
    self.ACTION.addMinutes                   = function ( timeout, minutes ) {
        var _command = 'date $(date +%m%d%H%M%Y.%S -d \'' + minutes + ' minutes\')';
        
        var _success = function ( _status, data ) {
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.dropDatabase                 = function ( timeout, database ) {
        var _command = "mongo " + database + " --eval " + "'db.dropDatabase()'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            self.COMMON.errorExecuteCommand( err );
        };
        
        self.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.dropAllDatabases             = function ( timeout ) {
        __do_next = false;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DAEMON.COMMON.ACTION.stopAll( 0, function () {
                _INTERNAL.dropAllDatabases();
                SHINKEN.TOOLS.TEST_AUTO_DAEMON.COMMON.ACTION.startAll( 4000,
                    function () {
                        SHINKEN.HIGHWAY.goTo( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
                    } );
            } );
        }, timeout );
    };
    self.ACTION.deleteManyMongo              = function ( timeout, database, collection, query ) {
        var _command = "mongo " + database + " --eval " + "'db.getCollection(\"" + collection + "\").remove(" + JSON.stringify( query ) + ")'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.upsertDocumentToMongo        = function ( timeout, database, collection, document_id, document ) {
        return SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.upsertStringDocumentToMongo( timeout, database, collection, document_id, JSON.stringify( document ) );
    };
    self.ACTION.upsertStringDocumentToMongo  = function ( timeout, database, collection, document_id, document_string ) {
        var _key_to_find = { "_id": document_id };
        var _command     = "mongo " + database + " --eval " + "'db.getCollection(\"" + collection + "\").update(" + JSON.stringify( _key_to_find ) + ", " + document_string + ", upsert=true)'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.executePostCommand           = function ( timeout, command, success, error ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.executePostCommand', command );
        setTimeout( function () {
            console.log( "executePostCommand", "[ - ]", command );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.COMUNICATION.requestPost( "http://" + SHINKEN.HIGHWAY.getHostName() + ":5000/push_commands", JSON.stringify( { "commands": command } ), success, error );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.getPythonPath                = function ( timeout, success, error ) {
        var _success = function ( _status, data ) {
            // delete \n of the python_path
            var python_path = data.stdout.slice( 0, -1 );
            success( _status, python_path );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, "python-shinken -c \"import shinken;import os;print(os.path.dirname(shinken.__file__))\"", _success, error );
    };
    //********************************************  ACTION   **************************************************//
    self.COMMON.errorExecuteCommand          = function ( err ) {
        SHINKEN.TOOLS.TEST_AUTO.addError( err );
        SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE || {} );
