//__lib__ lib_common
'use strict';

SHINKEN_LIST.HeadersWithSortFromData           = function () {
    this.current_index_sorting = 0;
};
SHINKEN_LIST.HeadersWithSortFromData.prototype = {
    init                       : function () {
    },
    _computeCurrentIndexSorting: function ( is_cumulative ) {
        this.current_index_sorting = (this.current_index_sorting && is_cumulative) ? this.current_index_sorting + 1 : 1;
    },
    cleanSorting               : function () {
        var _active_headers = this.getActiveSortingHeaders();
        for ( var i = 0, size_i = _active_headers.length; i < size_i; i++ ) {
            _active_headers[ i ].setSortingStatus( SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE );
        }
    },
    clickOnHeaderSorting       : function ( event, event_name, param ) {
        var _header = this.getContentByUUID( param );
        if ( !event.shiftKey && (_header.getSortingStatus() === SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE || this.current_index_sorting > 1) ) {
            this.cleanSorting();
        }
        if ( _header.getSortingIndex() ) {
            _header.clickOnButton( event, event_name, _header.getSortingIndex() );
        }
        else {
            this._computeCurrentIndexSorting( event.shiftKey );
            _header.clickOnButton( event, event_name, this.current_index_sorting );
        }
        this._computeAllIndexes();
    },
    _computeAllIndexes         : function () {
        var _active_headers = SHINKEN.TOOLS.ARRAY.cleanEmpty( this.getActiveSortingHeaders() );
        for ( var i = 0, size_i = _active_headers.length; i < size_i; i++ ) {
            _active_headers[ i ].setSortingIndex( i + 1 );
        }
        if ( !size_i ){
            this.current_index_sorting = 0;
        }
    },
    clickOnOptionHeaderSorting : function ( event, event_name, param ) {
        var _option_dom = DOM.Service.findParentElementWithClass( event.target, "shinken-list-header-sort-popup-option" );
        var _header     = this.getContentByUUID( param );
        var _to_set     = {};
        if ( _option_dom.dataset.status === SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE ) {
            var _index = _header.getSortingIndex();
            _to_set.index = 0;
        }
        else {
            if ( !this.getContentByUUID( param ).getSortingIndex() ) {
                this._computeCurrentIndexSorting( true );
                _to_set.index = this.current_index_sorting;
            }
            else {
                _to_set.index = this.getContentByUUID( param ).getSortingIndex();
            }
        }
        _to_set.status = _option_dom.dataset.status;
        _header.clickOnButton( event, event_name, _to_set );
        this._computeAllIndexes();
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeadersWithSortFromData, SHINKEN_LIST.HeadersFromData );