//priority 21
//__lib__ lib_common
'use strict';

SHINKEN.OBJECT.NotificationsOfChange = {};

SHINKEN.OBJECT.NotificationsOfChange._interface           = function () {
};

SHINKEN.OBJECT.NotificationsOfChange._interface.prototype = {
    init: function ( data ) {
        if ( data ) {
            this.updateData( data );
        }
    },
    initPhase: function ( ) {
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].initPhase();
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].initPhase();
    },
    //**************************************    EVENT LISTENER     **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "ask_play_notifications":
                this.doActionAfter( "ask_play_notification_visual_blink", param );
                this.doActionAfter( "ask_play_notification_of_sound", param );
                break;
            case "one_widget_with_change_detected":
            case "reset_change_detected":
            case "notification-configuration-set-dom-element-with-data":
                this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].doActionAfter( event_name, param );
                this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].doActionAfter( event_name, param );
                break;
            case "ask_play_notification_visual_blink":
            case "change_value_notification_of_change_visual_blink":
                this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].doActionAfter( event_name, param );
                break;
            case "ask_play_notification_of_sound":
            case "change_value_notification_of_change_sound":
                this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].doActionAfter( event_name, param );
                break;
        }
    },
    //**************************************    DATAS         **************************************************//
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND:
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL:
                this[ key ].updateData( value );
                break;
            default:
                console.warn( "[NotificationsOfChange]", "[IGNORED DATA]", "[" + key + "]", value );
        }
    },
    //**************************************    GETTER SETTER         **************************************************//
    getSoundValue          : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].getValue();
    },
    getVolumeValue          : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].getValue();
    },
    getBlinkValue          : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].getBlinkValue();
    },
    setPhaseDomElement          : function ( to_set, data_name ) {
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].setPhaseDomElement( to_set, data_name );
    },
    needToComputeWidgetHasChange: function ( user_notification_settings ) {
        return true; //TODO A FAIRE AVEC LES DONNEES UTILISATEURS
    },
    
    //**************************************    SAVE         **************************************************//
    getDataToSave: function () {
        var _to_return                                                         = {};
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ]  = this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].getDataToSave();
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ] = this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].getDataToSave();
        return _to_return;
    }
};