//priority 20
//__lib__ lib_common
'use strict';

SHINKEN.OBJECT.SLIDE_PANEL = {
    TYPE    : {
        HORIZONTAL_RIGHT: "HORIZONTAL_RIGHT",
        HORIZONTAL_LEFT : "HORIZONTAL_LEFT",
        VERTICAL_TOP    : "VERTICAL_TOP",
        VERTICAL_BOTTOM : "VERTICAL_BOTTOM"
    },
    POSITION: {
        RIGHT : "RIGHT",
        LEFT  : "LEFT",
        TOP   : "TOP",
        BOTTOM: "BOTTOM"
    },
    ACTION  : {
        PIN_TO_RIGHT : "pin-to-right",
        PIN_TO_LEFT  : "pin-to-left",
        PIN_TO_TOP   : "pin-to-top",
        PIN_TO_BOTTOM: "pin-to-bottom"
    }
};


SHINKEN.OBJECT.InterfaceSlidePanel           = function () {
};
SHINKEN.OBJECT.InterfaceSlidePanel.prototype = {
    init      : function () {
    },
    initCommon: function () {
        this.initPhase();
    },
    initSize  : function () {
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    openIfHasContent: function ( init_with_ratio, loading_message ) {
        if ( this.content_html ) {
            this.open( init_with_ratio, loading_message );
        }
    },
    open            : function ( init_with_ratio, loading_message ) {
        var _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.INIT:
                this.computeHtml();
                this.initSize( init_with_ratio );
                if ( loading_message ) {
                    this.setLoading( loading_message );
                }
                break;
            default:
                this.askOpen();
                break;
        }
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    },
    close           : function () {
        var _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.INIT:
                break;
            default:
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                this.askClose();
                break;
        }
    },
    clickOnButton   : function ( event, event_name, param ) {
        switch ( event_name ) {
            case SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_RIGHT:
                this.pinToRight();
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_LEFT:
                this.pinToLeft();
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_TOP:
                this.pinToTop();
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_BOTTOM:
                this.pinToBottom();
                break;
        }
    },
    //********************************************  SETTER GETTER  *****************************************************//
    setLoading           : function ( to_set ) {
        if ( !this.dom_element_loading ){
            this.dom_element_loading = DOM.Service.createElement( "div", { class: "shinken-panel-loading-container" } );
            var _content = DOM.Service.createElement( "div", { class: "shinken-panel-loading-content" } );
            this.dom_element_loading_message = DOM.Service.createElement( "div", { class: "shinken-panel-loading-message" } );
            var _icon    = DOM.Service.createElement( "div", { class: "shinken-panel-loading-icon" }, '<span class="shinkon shinkon-reload"></span>' );
            DOM.Service.addElementTo( this.dom_element_loading_message, _content );
            DOM.Service.addElementTo( _icon, _content );
            DOM.Service.addElementTo( _content, this.dom_element_loading );
        }
        this.dom_element_loading_message.innerHTML =  to_set;
        this.setContent( this.dom_element_loading );
    },
    setContent           : function ( to_set ) {
        this.content_html = to_set;
        DOM.Service.addElementToAfterEmpty( this.content_html, this.getDomElement() );
        this.computeSizes();
    },
    setName              : function ( to_set ) {
        this.name = to_set;
    },
    getName              : function () {
        return this.name;
    },
    setType              : function ( to_set ) {
        this.type = to_set;
    },
    setMainPartDomElement: function ( to_set ) {
        this.dom_element_parent    = to_set.parentElement;
        this.dom_element_main_part = to_set;
    },

    //********************************************  RESIZE  *****************************************************//
    computeAfterResize: function ( width, height ) {
    },
    computeSizes      : function () {
    },
    getCurrentRatio   : function () {
    },
    
    //********************************************  DRAG AND DROP  *****************************************************//
    onDragStart: function ( origin_x, origin_y ) {
        this.origin_x = origin_x;
        this.origin_y = origin_y;
    },
    onDragMove : function ( delta_x, delta_y ) {
        switch ( this.type ) {
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_LEFT:
                this.computeAfterDragMove( -delta_x );
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_RIGHT:
                this.computeAfterDragMove( delta_x );
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_TOP:
                this.computeAfterDragMove( delta_y );
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_BOTTOM:
                this.computeAfterDragMove( -delta_y );
                break;
        }
        
    },
    onDragStop : function () {
    }
    //********************************************  COMPUTE  *****************************************************//
    
    //********************************************  HTML   **************************************************//
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InterfaceSlidePanel, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InterfaceSlidePanel, SHINKEN.OBJECT.PhaseInterface );
