//__lib__ lib_common

SHINKEN_VALIDATION.Service = (function ( self ) {
    "use strict";
    self.isValid            = function ( value, validation_parameter ) {
        if ( value === "default" && !validation_parameter.is_mandatory ) {
            return true;
        }
        return _isValid( value, validation_parameter.validation_type, validation_parameter.validation_value, validation_parameter.is_mandatory );
    };
    self.parseToValidFormat = function ( param_value, validation_parameter ) {
        if ( param_value.getValue() === "default" ) {
            return;
        }
        
        
        _parseToValidFormat( param_value, validation_parameter.validation_type, validation_parameter.is_mandatory );
    };
    var _isValid            = function ( value, validation_type, validation_value, is_mandatory ) {
        if ( is_mandatory && value === "" ) {
            return false;
        }
        switch ( validation_type ) {
            case SHINKEN_VALIDATION.CONST.COLOR.CSS._KEY:
                if ( value ) {
                    if ( typeof value !== "string" ) {
                        return false;
                    }
                    if ( value.match( SHINKEN_VALIDATION.CONST.COLOR.CSS.REGEX ) ) {
                        return false;
                    }
                }
                break;
            case SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN:
                return SHINKEN.TOOLS.ARRAY.contains( validation_value, value );
            case SHINKEN_VALIDATION.CONST.NUMBER.FLOAT_POSITIVE:
                if ( !SHINKEN.TOOLS.NUMBER.isNumber( value ) ) {
                    return false;
                }
                if ( value < 0 ) {
                    return false;
                }
                break;
            case SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE:
                if ( !SHINKEN.TOOLS.NUMBER.isInteger( value ) ) {
                    return false;
                }
                if ( value < 0 ) {
                    return false;
                }
                break;
            case SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_BETWEEN:
                if ( !SHINKEN.TOOLS.NUMBER.isInteger( value ) ) {
                    return false;
                }
                if ( value < validation_value[ 0 ] ) {
                    return false;
                }
                if ( value > validation_value[ 1 ] ) {
                    return false;
                }
                break;
            case SHINKEN_VALIDATION.CONST.STRING.NOT_EMPTY:
                if ( typeof value !== "string" ) {
                    return false;
                }
                if ( value === "" ) {
                    return false;
                }
                break;
            case SHINKEN_VALIDATION.CONST.STRING.DONT_HAVE_FORBIDDEN:
                if ( typeof value !== "string" ) {
                    return false;
                }
                for ( var i = 0, _size_i = validation_value.length; i < _size_i; i++ ) {
                    if ( SHINKEN.TOOLS.STRING.contains( value, validation_value[ i ] ) ) {
                        return false;
                    }
                }
                break;
            case SHINKEN_VALIDATION.CONST.STRING.IS_STRING:
                return typeof value === "string";
            
            case SHINKEN_VALIDATION.CONST.OTHERS.DEFINE_STRING_OR_INTEGER_POSITIVE:
                if ( SHINKEN.TOOLS.ARRAY.contains( validation_value, value ) ) {
                    return true;
                }
                return _isValid( value, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE );
            case SHINKEN_VALIDATION.CONST.BOOLEAN._KEY:
                return SHINKEN.TOOLS.BOOLEAN.isBoolean( value );
            case undefined:
            case "":
                break;
            default:
                console.warn( "SHINKEN_VALIDATION.Service [_isValid] UNKNOWN KEY", validation_type );
                break;
        }
        return true;
    };
    var _parseToValidFormat = function ( param_value, validation_type ) {
        var _parsed_value = undefined;
        switch ( validation_type ) {
            case SHINKEN_VALIDATION.CONST.NUMBER.FLOAT_POSITIVE:
                _parsed_value = parseFloat( param_value.getValue() );
                break;
            case SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE:
            case SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_BETWEEN:
                _parsed_value = parseInt( param_value.getValue() );
                break;
            case SHINKEN_VALIDATION.CONST.OTHERS.DEFINE_STRING_OR_INTEGER_POSITIVE:
                if ( SHINKEN.TOOLS.NUMBER.isInteger( param_value.getValue() ) ) {
                    _parsed_value = parseInt( param_value.getValue() );
                }
                break;
            case SHINKEN_VALIDATION.CONST.BOOLEAN._KEY:
                if ( SHINKEN.TOOLS.BOOLEAN.isBoolean( param_value.getValue() ) ) {
                    _parsed_value = SHINKEN.TOOLS.BOOLEAN.parseToBoolean( param_value.getValue() );
                }
                break;
        }
        if ( typeof _parsed_value !== 'undefined' && _parsed_value !== param_value.getValue() ) {
            param_value.setValue( _parsed_value );
        }
    };
    return self;
})( SHINKEN_VALIDATION.Service || {} );
