//__lib__ lib_common
'use strict';

WINDOW.ElementGroupFromData           = function () {
    //dom_element
    //size
    //name
    this.list = {};
    this.init();
};
WINDOW.ElementGroupFromData.prototype = {
    init           : function () {
        this.initCounters();
        this.initName();
        this.initWindows();
        MANAGER.__instance_window_distributor.setParentWindow( this.name, this );
    },
    initWindows    : function () {
    },
    initName       : function () {
        this.name = SHINKEN.TOOLS.STRING.buildUUID();
    },
    initControllers: function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].initController();
        }
    },
    //********************************************  OTHER  *****************************************************//
    resizeDone        : function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].resizeDone();
        }
    },
    //********************************************  HTML  *****************************************************//
    computeHtml       : function () {
        var _onclick_attribute = 'MANAGER.EventManager.clickOnWindowNavigation(event, "' + this.name + '")';
        var _dom_tr            = DOM.Service.createElement( "tr", {
            "class"    : "shinken-window-group",
            "data-name": this.name,
            "onclick"  : _onclick_attribute
        } );
        var _keys              = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            DOM.Service.addElementTo( this.list[ _keys[ i ] ].dom_element, _dom_tr );
        }
        this.dom_element = DOM.Service.createElement( "table", { "class": this.getMainClass() } );
        DOM.Service.addElementTo( _dom_tr, this.dom_element );
        this.computeHtmlTargets();
    },
    computeHtmlTargets: function ( dom_parent ) {
        this.dom_element_targets = DOM.Service.createElement( "div", {
            "class": "shinken-window-targets"
        } );
        var _keys                = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            DOM.Service.addElementTo( this.list[ _keys[ i ] ].dom_element_target, this.getDomElementTargets() );
        }
    },
    getMainClass       : function () {
        return "shinken-window-element-table shinken-table";
    },
    //********************************************  EVENT LISTENER  **************************************************//
    onClick: function ( event ) {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].onClick( event );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroupFromData, WINDOW.ElementGroup );