#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

import os

IN_TESTING = 'PYCHARM_HOSTED' in os.environ

# Use only in pycharm for type hint
try:
    from typing import (
        Set,
        Dict,
        Any,
        Tuple,
        Union,
        List,
        Callable,
        Optional,
        Text,
        NoReturn,
        Type,
        cast,
        TYPE_CHECKING,
        Iterator,
        NewType,
        Literal,
        Collection,
        Iterable,
        Container,
        Generator,
        Sequence,
        Final,
        TypeVar
    )
    
    ShinkenIterable = Union[Tuple, List, Set]
    Str = Union[str, unicode]
    Number = Union[float, int]
    WrappedFunction = TypeVar('WrappedFunction', bound=Callable)

except ImportError:
    class GenericType(object):
        def __getitem__(self, a):
            pass
    
    
    # noinspection PyUnusedLocal
    def cast(x, y):
        return y
    
    
    def _type_mock(p):
        return p
    
    
    # noinspection PyPep8Naming,PyUnusedLocal
    def NewType(name, tp):
        return _type_mock
    
    
    # noinspection PyPep8Naming,PyUnusedLocal
    def TypeVar(name, *constraints, **kwargs):
        return object()
    
    
    TYPE_CHECKING = False
    Literal = GenericType()
    Set = GenericType()
    Dict = GenericType()
    Any = GenericType()
    Tuple = GenericType()
    Union = GenericType()
    List = GenericType()
    Callable = GenericType()
    Optional = GenericType()
    Text = GenericType()
    NoReturn = GenericType()
    Type = GenericType()
    Iterator = GenericType()
    Str = GenericType()
    Number = GenericType()
    Collection = GenericType()
    Iterable = GenericType()
    Generator = GenericType()
    Final = GenericType()
    ShinkenIterable = GenericType()
    Sequence = GenericType()
    WrappedFunction = object()
