#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import NoReturn, Type, Optional, List

from shinkensolutions.api.synchronizer.source.display_origin_item.display_origin_item_format import DisplayOriginItemFormat
from shinkensolutions.api.synchronizer.source.mapping.origin_to_source.mapper import AbstractMapperOriginToSource
from shinkensolutions.api.synchronizer.source.source_configuration_value import SERVICE_MODE, ServiceMode
from shinkensolutions.api.synchronizer.source.source_exception import SourceException


class SourceConfiguration(object):
    
    def __init__(self):
        self._state_of_mapping_origin_to_source = SERVICE_MODE.ON
        self._origin_to_source_type_mapper = None  # type: Optional[Type[AbstractMapperOriginToSource]]
        self._origin_to_source_mappers_name = []  # type: List[str]
        
        self._state_of_host_template_binding_rule = SERVICE_MODE.ON
        
        self._state_of_display_origin_item = SERVICE_MODE.ON
        self._display_origin_item_format = None  # type: Optional[DisplayOriginItemFormat]
        
        self._state_of_api_item_properties = SERVICE_MODE.OFF
        
        self._state_of_origin_item_properties_description = SERVICE_MODE.ON
        self._origin_item_description_class = None
        self._api_item_properties_class = None
    
    
    def set_mapping_origin_to_source(self, state, mapper=None, mappers_name=None):
        # type: (ServiceMode, Type[AbstractMapperOriginToSource], Optional[List[str]]) -> NoReturn
        self._check_value(state, 'mapping_origin_to_source')
        self._state_of_mapping_origin_to_source = state
        self._origin_to_source_type_mapper = mapper
        self._origin_to_source_mappers_name = mappers_name or []
    
    
    def set_host_template_binding_rule(self, value):
        # type: (ServiceMode) -> NoReturn
        self._check_value(value, 'service_host_template_binding_rule')
        self._state_of_host_template_binding_rule = value
    
    
    def set_display_origin_item(self, value, display_origin_item_format):
        # type: (ServiceMode, DisplayOriginItemFormat ) -> NoReturn
        self._check_value(value, 'service_display_origin_item')
        
        self._state_of_display_origin_item = value
        self._display_origin_item_format = display_origin_item_format
    
    
    def set_api_item_properties(self, value):
        # type: (ServiceMode ) -> NoReturn
        self._check_value(value, 'set_api_item_properties')
        self._state_of_api_item_properties = value
    
    
    def set_origin_item_properties_description(self, value):
        # type: (ServiceMode ) -> NoReturn
        self._check_value(value, 'origin_item_properties_description')
        self._state_of_origin_item_properties_description = value
    
    
    @staticmethod
    def _check_value(value, service_name):
        if value not in SERVICE_MODE._SERVICE_MODE_VALUES:
            raise SourceException('Possible value for %s are %s, you set : %s' % (service_name, ','.join(SERVICE_MODE._SERVICE_MODE_VALUES), value))
    
    
    def set_origin_item_description_class(self, origin_item_description_class):
        # type: (Type) -> None
        self._origin_item_description_class = origin_item_description_class
    
    
    def set_api_item_properties_class(self, api_item_properties_class):
        # type: (Type) -> None
        self._api_item_properties_class = api_item_properties_class
