SHINKEN.TOOLS.TEST_AUTO_WINDOW = (function ( self ) {
    self.DOM             = {};
    self.TEST            = {};
    self.TEST.JS         = {};
    self.ACTION          = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.window      = function ( id ) {
        var _to_return = document.getElementById( id );
        return [
            _to_return,
            _to_return.querySelector( ".shinken-error-counter" ),
            _to_return.querySelector( ".shinken-warning-counter" ),
            __version_shinken === "V02.07.06" ? _to_return.querySelector( "#id-shinken-nb-checks" ) : _to_return.querySelector( ".shinken-window-total-counter" ),
            _to_return.querySelector( ".shinken-user-set-counter" )
        ];
    };
    //********************************************  Test   **************************************************//
    self.TEST.counter    = function ( timeout, id, nb_error, nb_warning, nb_total, nb_user ) {
        setTimeout( function () {
            var _window = self.DOM.window( id );
            if ( nb_error !== undefined ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _window[ 1 ], nb_error );
            }
            if ( nb_warning !== undefined ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _window[ 2 ], nb_warning );
            }
            if ( nb_total !== undefined ) {
                if ( __version_shinken === "V02.07.06" ) {
                    SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _window[ 3 ].innerText, nb_total + "", "counter <span class='shinken-data-user'>total window</span>" );
                }
                else {
                    SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _window[ 3 ], nb_total );
                }
            }
            if ( nb_user !== undefined ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _window[ 4 ], nb_user );
            }
        }, timeout );
        return 100;
    };
    self.TEST.isSelected = function ( timeout, id, boolean_expected ) {
        setTimeout( function () {
            var _window = self.DOM.window( id );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasClass( 0, _window[ 0 ], 'shinken-active', boolean_expected, "Window isSelected for " + _window[ 0 ].innerText );
        }, timeout );
        return 100;
    };
    //********************************************  TEST   **************************************************//
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_WINDOW || {} );

SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT_EDITION = (function ( self ) {
    self.ACTION               = {};
    self.ACTION.navigateInTab = function ( timeout, tab_name ) {
        setTimeout( function () {
            if ( __version_shinken === "V02.07.06" ) {
                document.querySelector( "#" + WINDOW.CONST.ID.WINDOW_TAB + tab_name + " .shinken-link" ).click();
            }
            else {
                document.getElementById( WINDOW.CONST.ID.WINDOW_TAB + tab_name ).click();
            }
        }, timeout );
        return 100;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT_EDITION || {} );