SHINKEN.TOOLS.TEST_AUTO_LIST_ALL = (function ( self ) {
    self.DOM                                                = {};
    self.ACTION                                             = {};
    self.TEST                                               = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getMassActionContainer                         = function () {
        if ( __version_shinken === "V02.07.06" ){
            return document.getElementById( "select-mass-action" );
        }
        return document.getElementById( "id-shinken-select-mass-action" );
    };
    self.DOM.getMassActionSelector                          = function () {
        return self.DOM.getMassActionContainer().querySelector( ".shinken-select-selector" );
    };
    self.DOM.getMassActionOptions                           = function () {
        return self.DOM.getMassActionContainer().querySelectorAll( ".shinken-option" );
    };
    self.DOM.getFirstActiveMassActionOption                 = function ( option_name ) {
        if ( __version_shinken === "V02.07.06" ) {
            return self.DOM.getMassActionContainer().querySelector( '.shinken-option.shinken-active-option-staging[data-key-name="' + option_name + '"]' );
        }
        return self.DOM.getMassActionContainer().querySelector( '.shinken-option.shinken-active[data-key-name="' + option_name + '"]' );
    };
    self.DOM.configurationButton                            = function () {
        return document.querySelector( '.shinken-button[data-name="configuration_columns"]' );
    };
    self.DOM.configuration_addColumnButton                            = function ( column_name ) {
        return document.querySelector( '#id-shinken-list-pop-up-columns .shinken-button[data-column-name="' + column_name + '"]' );
    };
    self.DOM.headerContainer                            = function (  ) {
        return document.getElementById( 'id-shinken-header-row' );
    };
    self.DOM.headers                            = function (  ) {
        return self.DOM.headerContainer().querySelectorAll('.cell' );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnConfigurationButton                  = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.configurationButton() );
        }, timeout );
        return 400;
    };
    self.ACTION.addExtraColumn                  = function ( timeout, column_name ) {
        setTimeout( function () {
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                var _button = self.DOM.configuration_addColumnButton(column_name);
                if ( _button ) {
                    SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextLink( __shinken_test_type, __phase + 1, true ) );
                }
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _button );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le test comporte des erreurs, la dernière action n'a pas été faites" );
            }
        }, timeout );
        return 400;
    };
    self.ACTION.selectShinkenElement                        = function ( timeout, test_type ) {
        setTimeout( function () {
            if ( !test_type ) {
                test_type = __shinken_test_type;
            }
            switch ( test_type ) {
                case "00067":
                case "00068":
                case "00069":
                case "00070":
                case "00071":
                case "00072":
                case "00073":
                case "00074":
                case "00075":
                case "00076":
                case "00077":
                case "00078":
                case "00079":
                case "00080":
                case "00082":
                case "00083":
                case "00092":
                case "00093":
                case "00123":
                case "00126":
                case "00129":
                case "00168":
                    document.getElementById( "00000000000000000000000000000001" ).click();
                    break;
                case "00127":
                    document.getElementById( "22000000000000000000000000000000" ).click();
                    break;
                case "00082-3":
                case "00082-6":
                    document.getElementById( "00000000000000000000000000000001" ).click();
                    document.getElementById( "00000000000000000000000000000002" ).click();
                    document.getElementById( "01000000000000000000000000000000" ).click();
                    break;
                case "00082-4":
                    document.getElementById( "00000000000000000000000000000001" ).click();
                    document.getElementById( "00000000000000000000000000000002" ).click();
                    document.getElementById( "00000000000000000000000000000003" ).click();
                    break;
                case "00083-3":
                case "00083-6":
                case "00083-8":
                    document.getElementById( "00000000000000000000000000000001" ).click();
                    document.getElementById( "00000000000000000000000000000002" ).click();
                    break;
                case "00094":
                    document.getElementById( SHINKEN.TOOLS.TEST_AUTO.CONST.DEFAULT_CONFIG_TEST_AUTO_VALID.CHECK_TEMPLATE.TEST_AUTO_VALID.DATA._id ).click();
                    break;
                case "00128":
                    document.getElementById( SHINKEN.TOOLS.TEST_AUTO.CONST.DEFAULT_CONFIG_TEST_AUTO_VALID.TIMEPERIOD.TEST_AUTO_VALID.DATA._id ).click();
                    break;
                case "00130":
                    switch ( __phase ) {
                        case 3:
                            document.getElementById( "00000000000000000000000000000003" ).click();
                            break;
                        default:
                            document.getElementById( "00000000000000000000000000000001" ).click();
                            break;
                    }
                    break;
                case "00132":
                    if ( __phase === 2 ) {
                        document.getElementById( "00000000000000000000000000000133" ).click();
                    }
                    document.getElementById( "00000000000000000000000000000132" ).click();
                    break;
                case "00133":
                    document.getElementById( "00000000000000000000000000000132" ).click();
                    break;
                case "00134":
                    document.getElementById( "00000000000000000000000000000134" ).click();
                    break;
                case "00144":
                    document.getElementById( "00000000000000000000000000000144" ).click();
                    break;
                case "00146":
                    document.getElementById( "10000000000000000000000000000146" ).click();
                    break;
                case "00148":
                    document.getElementById( "00000000000000000000000000000146" ).click();
                    break;
                case "00149":
                    document.getElementById( "10000000000000000000000000000149" ).click();
                    break;
                case "00150":
                    document.getElementById( "10000000000000000000000000000150" ).click();
                    break;
                case "00151":
                    document.getElementById( "10000000000000000000000000000151" ).click();
                    break;
                case "00152":
                    document.getElementById( "10200000000000000000000000000152" ).click();
                    break;
                case "00153":
                    document.getElementById( "10100000000000000000000000000153" ).click();
                    break;
                case "00154":
                    document.getElementById( "10000000000000000000000000000154" ).click();
                    break;
                case "00155":
                    document.getElementById( "10200000000000000000000000000155" ).click();
                    break;
                case "00156":
                    document.getElementById( "10200000000000000000000000000156" ).click();
                    break;
                case "00157":
                    document.getElementById( "10000000000000000000000000000157" ).click();
                    break;
                case "00167":
                case "00170":
                    document.getElementById( "00000000000000000000000000000001" ).click();
                    document.getElementById( "00000000000000000000000000000003" ).click();
                    break;
                case "00169":
                    document.getElementById( "00000000000000000000000000000001" ).click();
                    document.getElementById( "00000000000000000000000000000006" ).click();
                    break;
                case "00174":
                    document.getElementById( "00000000000000000000000000000003" ).click();
                    document.getElementById( "00000000000000000000000000000006" ).click();
                    break;
                case "00177":
                    document.getElementById( "06000000000000000000000000000000" ).click();
                    break;
                case "ALL":
                default:
                    document.getElementById( "all-changes-checkbox" ).click();
                    break;
            }
        }, timeout );
        return 1000;
    };
    self.ACTION.selectMassActionIfPossible                  = function ( mass_action_name ) {
        var _dom_action = self.DOM.getFirstActiveMassActionOption( mass_action_name );
        if ( _dom_action ) {
            SHINKEN.TOOLS.TEST_AUTO_DOM.mouseup( 0, _dom_action );
            return true;
        }
        return false;
    };
    self.ACTION.selectMassAction                            = function ( timeout, mass_action_name ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'selectMassAction', mass_action_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( __version_shinken === "V02.07.06" ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getFirstActiveMassActionOption( mass_action_name ), true );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.mouseup( 0, self.DOM.getFirstActiveMassActionOption( mass_action_name ), true );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.selectAndClickOnExecuteMassActionIfPossible = function ( timeout, mass_action_name ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'selectAndClickOnExecuteMassActionIfPossible', mass_action_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( self.ACTION.selectMassActionIfPossible( mass_action_name ) ) {
                self.ACTION.clickOnExecuteMassAction( 0 );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnExecuteMassAction                    = function ( timeout, skip_do_next ) {
        setTimeout( function () {
            var _button = document.getElementById( 'btn-action-launch' );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                var _timeout = SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _button );
                setTimeout( function (  ) {
                if ( !skip_do_next ) {
                        if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                    SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextLink( __shinken_test_type, __phase + 1 ) );
                }
                    }
                }, _timeout )
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le test comporte des erreurs, la dernière action n'a pas été faites" );
            }
            
        }, timeout );
        return 2000;
    };
    self.ACTION.clickOnExecuteMassActionWithComment         = function ( timeout ) {
        setTimeout( function () {
            document.getElementById( "btn-action-launch" ).click();
        }, timeout );
        return 1000;
    };
    self.ACTION.simulatePressEnterToValid                   = function ( timeout, filter_name, _avoid_next_phase ) {
        setTimeout( function () {
            setTimeout( function () {
                if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                    if ( !_avoid_next_phase ) {
                        SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
                    }
                    var _dom_element = MANAGER.__instance_filter_distributor.getElement( filter_name ).component.input.dom_element_input;
                    SHINKEN.TOOLS.TEST_AUTO.___dispatchMouseEvent( _dom_element, 'click' );
                    setTimeout( function () {
                        SHINKEN.TOOLS.TEST_AUTO.___dispatchEnterKeyEvent( _dom_element, "keydown" );
                    }, 300 );
                }
            }, 1000 );
        }, timeout );
        return 3000;
    };
    self.ACTION.switchMassActionSelectorState               = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getMassActionSelector() );
        }, timeout );
        return 300;
    };
    self.ACTION.do_mass_action_without_UI                   = function ( timeout, code_expected, mass_action, by_pass_work_area, switch_case_value ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'do_mass_action_without_UI', mass_action );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK", _to_return );
                return;
            }
            self.__do__request( self.__get__request__url( mass_action, by_pass_work_area ), self.__get__request__data( switch_case_value ), code_expected );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.__get__request__data                               = function ( switch_value ) {
        //var _to_return = {"elements":{"hosts":["000000000000000000000001","00000000000000000000000000000001","00000000000000000000000000000002"]},"object_count":3};
        var _to_return = { "elements": {}, "object_count": 0 };
        if ( !switch_value ) {
            switch_value = __shinken_test_type + "-" + __phase;
        }
        switch ( switch_value ) {
            case "00184-2":
            case "00184-3":
                _to_return[ "elements" ][ "hosts" ] = ["00000000000000000000000000000001"];
                _to_return[ "object_count" ]        = 1;
                break;
        }
        return _to_return;
    };
    self.__get__request__url                                = function ( mass_action, by_pass_work_area ) {
        var _to_return = "";
        var item_state = "";
        switch ( mass_action ) {
            case SHINKEN.TOOLS.TEST_AUTO_LIST_ALL.CONST.MASS_CHANGE_ACTION_IMPORT:
                _to_return = "/elements/q/" + mass_action + "/?";
                item_state = "new";
                break;
            case SHINKEN.TOOLS.TEST_AUTO_LIST_ALL.CONST.MASS_CHANGE_ACTION_DIFFERENCE:
                _to_return = "/elements/q/" + mass_action + "/?";
                item_state = "stagging";
                break;
        }
        var url_params = [
            'item_state=' + item_state,
            'bypass_work_area=' + by_pass_work_area,
            'ts=' + Date.now()
        ];
        _to_return     = _to_return + url_params.join( '&' );
        return _to_return;
    };
    self.__do__request                                      = function ( url, data, code_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        $.ajax( {
            url        : url,
            type       : 'POST',
            contentType: 'application/json',
            data       : JSON.stringify( data ),
            dataType   : 'json'
        } ).success(
            function ( data ) {
                if ( typeof code_expected !== "object" ) {
                    code_expected = [code_expected];
                }
                if ( !SHINKEN.TOOLS.ARRAY.contains( code_expected, data.rc ) ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " La sauvegarde de l'élement n'a pas réussi [SUCCESS]" + JSON.stringify( data ) );
                }
            }
        ).error(
            function ( res ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " La sauvegarde de l'élement n'a pas réussi [ERROR]" + res.responseText );
            }
        );
    };
    //********************************************  SETTER GETTER   **************************************************//
    self.ACTION.enterFilter                                 = function ( filter_name, value ) {
        MANAGER.__instance_filter_distributor.getElement( filter_name ).component.input.validation_rules = MANAGER.__instance_filter_distributor.getElement( filter_name ).component.input.validation_rules_not_focus;
        MANAGER.__instance_filter_distributor.getElement( filter_name ).setValue( value );
        MANAGER.__instance_filter_distributor.getElement( filter_name ).askComputeAfterChange();
    };
    //********************************************  TEST   **************************************************//
    self.TEST.columnNumber                                = function ( timeout, nb_total ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.headers(), nb_total, "nb élement total de header" );
        }, timeout );
        return 50;
    };
    self.TEST.elementsNumber                                = function ( timeout, nb_total, nb_new, nb_diff ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( document.getElementById( "id-shinken-total-list-element-number" ), nb_total, "nb élement total de la liste" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( document.getElementById( "id-shinken-total-new-list-element-number" ), nb_new, "nb élement total de la liste en nouveau" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( document.getElementById( "id-shinken-total-diff-list-element-number" ), nb_diff, "nb élement total de la liste en difference" );
        }, timeout );
        return 50;
    };
    self.TEST.filterValidation                              = function ( timeout, filter_name, value, nb_error_expected, _nb_warning_expected ) {
        setTimeout( function () {
            self.ACTION.enterFilter( filter_name, value );
            SHINKEN.TOOLS.TEST_AUTO_LIST_FILTER.TEST.validation_value( 300, filter_name, nb_error_expected, _nb_warning_expected, value );
        }, timeout );
        return 1000;
    };
    self.TEST.massActionsOptions                            = function ( timeout, nb_actions ) {
        setTimeout( function () {
            self.ACTION.switchMassActionSelectorState( 0 );
            var _options = self.DOM.getMassActionOptions();
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _options, nb_actions, "nb options" );
            for ( var i = 0, _size_i = _options.length; i < _size_i; i++ ) {
                self.TEST.massActionOptionCounter( _options[ i ] );
                SHINKEN.TOOLS.TEST_AUTO.___dispatchMouseEvent( _options[ i ], 'mouseenter' );
            }
        }, timeout );
        return 100;
    };
    //********************************************  PRIVATE   **************************************************//
    self.TEST.massActionOptionCounter                       = function ( option ) {
        var _value          = "";
        var _display        = "block";
        var _pointer_events = "none";
        var _case           = __shinken_test_type + "-" + __phase + "-" + option.dataset.keyName + "-" + option.dataset.state;
        var _under_filter   = '';
        switch ( option.dataset.keyName ) {
            case ACTIONS.NONE:
                _display = 'none';
                break;
        }
        switch ( _case ) {
            case "00082-7-submit-mass-action-work-area":
            case "00082-7-unlock-mass-action-work-area":
            
            case "00082-8-submit-mass-action-work-area":
            case "00082-8-unlock-mass-action-work-area":
            
            case "00082-9-submit-mass-action-work-area":
            case "00082-9-unlock-mass-action-work-area":
                _display = 'none';
                break;
        }
        switch ( _case ) {
            case "00082-2-massive_change-mass-action-work-area":
            case "00082-2-disable-mass-action-work-area":
            case "00082-2-delete-mass-action-work-area":
            case "00082-2-clone-mass-action-work-area":
            case "00082-2-create_from-mass-action-work-area":
            
            case "00082-3-enable-mass-action-work-area":
            case "00082-3-disable-mass-action-work-area":
            case "00082-3-import-mass-action-work-area":
            
            case "00082-5-massive_change-mass-action-work-area":
            case "00082-5-enable-mass-action-work-area":
            case "00082-5-delete-mass-action-work-area":
            case "00082-5-clone-mass-action-work-area":
            case "00082-5-create_from-mass-action-work-area":
            case "00082-5-submit-mass-action-work-area":
            case "00082-5-unlock-mass-action-work-area":
            
            case "00082-6-massive_change-mass-action-work-area":
            case "00082-6-enable-mass-action-work-area":
            case "00082-6-delete-mass-action-work-area":
            case "00082-6-import-mass-action-work-area":
            case "00082-6-apply-mass-action-work-area":
            case "00082-6-reject-mass-action-work-area":
            
            case "00082-8-clone-mass-action-work-area":
            case "00082-8-create_from-mass-action-work-area":
            case "00082-8-apply-mass-action-work-area":
            case "00082-8-reject-mass-action-work-area":
            
            case "00082-9-massive_change-mass-action-work-area":
            case "00082-9-enable-mass-action-work-area":
            case "00082-9-delete-mass-action-work-area":
            case "00082-9-clone-mass-action-work-area":
            case "00082-9-create_from-mass-action-work-area":
            
            case "00083-2-massive_change-mass-action-work-area":
            case "00083-2-disable-mass-action-work-area":
            case "00083-2-delete-mass-action-work-area":
            case "00083-2-clone-mass-action-work-area":
            case "00083-2-create_from-mass-action-work-area":
            
            case "00083-3-enable-mass-action-work-area":
            case "00083-3-disable-mass-action-work-area":
            
            case "00083-5-massive_change-mass-action-work-area":
            case "00083-5-enable-mass-action-work-area":
            case "00083-5-delete-mass-action-work-area":
            case "00083-5-clone-mass-action-work-area":
            case "00083-5-create_from-mass-action-work-area":
            
            case "00083-6-massive_change-mass-action-work-area":
            case "00083-6-enable-mass-action-work-area":
            case "00083-6-delete-mass-action-work-area":
            case "00083-6-apply-mass-action-work-area":
            case "00083-6-reject-mass-action-work-area":
            
            case "00083-8-enable-mass-action-work-area":
            case "00083-8-disable-mass-action-work-area":
            
            case "00085-2-import-mass-action":
                _value = 1;
                break;
            case "00082-3-massive_change-mass-action-work-area":
            case "00082-3-delete-mass-action-work-area":
            case "00082-3-clone-mass-action-work-area":
            case "00082-3-create_from-mass-action-work-area":
            
            case "00083-3-massive_change-mass-action-work-area":
            case "00083-3-delete-mass-action-work-area":
            case "00083-3-clone-mass-action-work-area":
            case "00083-3-create_from-mass-action-work-area":
            
            case "00082-6-clone-mass-action-work-area":
            case "00082-6-create_from-mass-action-work-area":
            
            case "00083-6-clone-mass-action-work-area":
            case "00083-6-create_from-mass-action-work-area":
            
            case "00083-8-massive_change-mass-action-work-area":
            case "00083-8-delete-mass-action-work-area":
            case "00083-8-clone-mass-action-work-area":
            case "00083-8-create_from-mass-action-work-area":
                _value = 2;
                break;
            case "00084-2-enable-mass-action-work-area":
                _value = 3;
                break;
            case "00084-2-disable-mass-action-work-area":
                _value = 7;
                break;
            case "00084-2-delete-mass-action-work-area":
            case "00084-2-clone-mass-action-work-area":
            case "00084-2-create_from-mass-action-work-area":
                _value = 10;
                break;
            case "00084-2-enable-mass-action":
                _value = 3;
                break;
            case "00084-2-disable-mass-action":
                _value = 7;
                break;
            case "00084-2-delete-mass-action":
            case "00084-2-clone-mass-action":
            case "00084-2-create_from-mass-action":
                _value = 10;
                break;
            case "00084-2-import-mass-action":
                _value = 1;
                break;
            case "00085-2-enable-mass-action":
                _value = 3;
                break;
            case "00085-2-disable-mass-action":
                _value = 7;
                break;
            case "00085-2-massive_change-mass-action":
            case "00085-2-delete-mass-action":
            case "00085-2-clone-mass-action":
            case "00085-2-create_from-mass-action":
                _value = 10;
                break;
        }
        switch ( _case ) {
            case "00082-2-massive_change-mass-action-work-area":
            case "00082-2-disable-mass-action-work-area":
            case "00082-2-delete-mass-action-work-area":
            case "00082-2-clone-mass-action-work-area":
            case "00082-2-create_from-mass-action-work-area":
            
            case "00082-3-massive_change-mass-action-work-area":
            case "00082-3-enable-mass-action-work-area":
            case "00082-3-disable-mass-action-work-area":
            case "00082-3-delete-mass-action-work-area":
            case "00082-3-clone-mass-action-work-area":
            case "00082-3-create_from-mass-action-work-area":
            case "00082-3-import-mass-action-work-area":
            
            case "00082-5-massive_change-mass-action-work-area":
            case "00082-5-enable-mass-action-work-area":
            case "00082-5-delete-mass-action-work-area":
            case "00082-5-clone-mass-action-work-area":
            case "00082-5-create_from-mass-action-work-area":
            case "00082-5-submit-mass-action-work-area":
            case "00082-5-unlock-mass-action-work-area":
            
            case "00082-6-massive_change-mass-action-work-area":
            case "00082-6-enable-mass-action-work-area":
            case "00082-6-delete-mass-action-work-area":
            case "00082-6-clone-mass-action-work-area":
            case "00082-6-create_from-mass-action-work-area":
            case "00082-6-import-mass-action-work-area":
            
            case "00082-8-clone-mass-action-work-area":
            case "00082-8-create_from-mass-action-work-area":
            case "00082-8-apply-mass-action-work-area":
            case "00082-8-reject-mass-action-work-area":
            
            case "00082-9-massive_change-mass-action-work-area":
            case "00082-9-enable-mass-action-work-area":
            case "00082-9-delete-mass-action-work-area":
            case "00082-9-clone-mass-action-work-area":
            case "00082-9-create_from-mass-action-work-area":
            
            case "00083-6-apply-mass-action-work-area":
            case "00083-6-reject-mass-action-work-area":
            
            case "00084-2-enable-mass-action":
            case "00084-2-disable-mass-action":
            case "00084-2-delete-mass-action":
            case "00084-2-clone-mass-action":
            case "00084-2-create_from-mass-action":
            case "00084-2-import-mass-action":
            
            case "00085-2-massive_change-mass-action":
            case "00085-2-enable-mass-action":
            case "00085-2-disable-mass-action":
            case "00085-2-delete-mass-action":
            case "00085-2-clone-mass-action":
            case "00085-2-create_from-mass-action":
            case "00085-2-import-mass-action":
                _pointer_events = "all";
                break;
            
        }
        SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( option.querySelector( ".shinken-counter" ), _value, "counter de l'action " + option.dataset.keyName + " [" + option.dataset.state + "]" );
        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( option, "pointerEvents", _pointer_events );
        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( option, "display", _display );
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_LIST_ALL || {} );

SHINKEN.TOOLS.TEST_AUTO_LIST_ALL.CONST = {
    MASS_CHANGE_ACTION_IMPORT    : "validate",
    MASS_CHANGE_ACTION_DIFFERENCE: "validate-changes"
};
SHINKEN.TOOLS.TEST_AUTO_LIST_FILTER    = (function ( self ) {
    self.DOM                       = {};
    self.ACTION                    = {};
    self.TEST                      = {};
    //********************************************  DOM **************************************************//
    self.DOM.filter                = function ( filter_name ) {
        return document.querySelector( '.shinken-list-select-input[data-name="' + filter_name + '"]' );
    };
    self.DOM.filterInput           = function ( filter_name ) {
        return self.DOM.filter( filter_name ).querySelector( '.shinken-input' );
    };
    //********************************************  ACTION **************************************************//
    self.ACTION.clickOnInput       = function ( timeout, filter_name ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.filterInput( filter_name ) );
        }, timeout );
        return 200;
    };
    self.ACTION.moveAutoCursorDown = function ( timeout, filter_name, _avoid_next_phase ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___dispatchKeyEvent( self.DOM.filterInput( filter_name ), "keydown", 'ArrowDown', 40 );
        }, timeout );
        return 500;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.validation_value     = function ( timeout, filter_name, nb_error_expected, nb_warning_expected, value ) {
        setTimeout( function () {
            var _filter = MANAGER.__instance_filter_distributor.getElement( filter_name );
            if ( !value ) {
                value = _filter.component.input.getDomValue();
            }
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _filter.component.input.getCounterError().getValue(), nb_error_expected, "Error pour <span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( value ) + "</span> => " );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _filter.component.input.getCounterWarning().getValue(), nb_warning_expected, "Warning pour <span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( value ) + "</span> => " );
            if ( nb_error_expected ) {
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _filter.component.input.dom_element_input, "backgroundColor", "rgb(253, 3, 0)" );
            }
            else if ( nb_warning_expected ) {
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _filter.component.input.dom_element_input, "backgroundColor", "rgb(253, 132, 3)" );
            }
        }, timeout );
        return 1000;
    };
    self.TEST.hasValue             = function ( timeout, filter_name, value ) {
        setTimeout( function () {
            var _filter = MANAGER.__instance_filter_distributor.getElement( filter_name );
            SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( _filter.component.input.dom_element_input, 'value', value, filter_name + " :" );
        }, timeout );
        return 200;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_LIST_FILTER || {} );

