SHINKEN.TOOLS.TEST_AUTO_PAGE_EDIT = (function ( self ) {
    self.DOM                                 = {};
    self.ACTION                              = {};
    self.TEST                                = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getLeftColumn                   = function () {
        return document.getElementById( "left-column" );
    };
    self.DOM.getRightColumn                  = function () {
        return document.getElementById( "right-column" );
    };
    self.DOM.getProperty                     = function ( property_name ) {
        return self.DOM.getRightColumn().querySelector( ".shinken-element-property-line[data-name=\"" + property_name + "\"]" );
    };
    self.DOM.getSelectPropertyOptions        = function ( property_name ) {
        return self.DOM.getProperty( property_name ).querySelectorAll( ".shinken-option" );
    };
    self.DOM.getSelectPropertySpecificOption = function ( property_name, option_to_get ) {
        return self.DOM.getProperty( property_name ).querySelector( ".shinken-option[data-key-name=\"" + option_to_get + "\"]" );
    };
    self.DOM.getPropertyInput                = function ( property_name ) {
        return self.DOM.getProperty( property_name ).querySelector( ".shinken-input" );
    };
    //********************************************  ACTION   **************************************************//
    //********************************************  TEST   **************************************************//
    self.TEST.propertyIsProtected          = function ( timeout, property_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.propertyIsProtected', property_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var property_input = self.DOM.getPropertyInput( property_name );
            if ( property_input.getAttribute( "type" ) !== "shinken-password" ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( property_name + " is not protected" );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.selectPropertyOptionIsLocked = function ( timeout, property_name, option_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.selectPropertyOptionIsLocked', property_name + "-" + option_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var option = self.DOM.getSelectPropertySpecificOption( property_name, option_name );
            if ( !option.classList.contains( "shinken-option-locked" ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Option " + option_name + " is not locked on property " + property_name );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_PAGE_EDIT || {} );

