SHINKEN.TOOLS.TEST_AUTO_DAEMON = (function ( self ) {
    self.COMMON                                              = {};
    self.COMMON.ACTION                                       = {};
    self.COMMON.TEST                                         = {};
    self.ARBITER                                             = {};
    self.ARBITER.TEST                                        = {};
    self.ARBITER.ACTION                                      = {};
    self.SYNCHRONIZER                                        = {};
    self.SYNCHRONIZER.ACTION                                 = {};
    self.SYNCHRONIZER.TEST                                   = {};
    var _INTERNAL                                            = {};
    self.SCHEDULER                                           = {};
    self.SCHEDULER.TEST                                      = {};
    self.SCHEDULER.ACTION                                    = {};
    self.BROKER                                              = {};
    self.BROKER.TEST                                         = {};
    self.BROKER.ACTION                                       = {};
    //********************************************  COMMON   **************************************************//
    self.COMMON.ACTION.addRealm = function ( timeout, realm_name, restart ) {
        var _to_return = restart ? 16000 : 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.addRealm", realm_name );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _command = 'echo -e "define realm {\nrealm_name ' + realm_name + '\n}" > /etc/shinken/realms/' + realm_name + '.cfg'
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, _command, function ( _status, data ) {
                if ( restart ) {
                    self.SYNCHRONIZER.ACTION.restart();
                    self.ARBITER.ACTION.restart();
                }
            }, function ( err ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "-- add realm" );
                SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
            } );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.COMMON.ACTION.removeRealm = function ( timeout, realm_name, restart ) {
        var _to_return = restart ? 16000 : 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.removeRealm", realm_name );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _command = 'rm -rf /etc/shinken/realms/' + realm_name + '.cfg'
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, _command, function ( _status, data ) {
                if ( restart ) {
                    self.SYNCHRONIZER.ACTION.restart();
                    self.ARBITER.ACTION.restart();
                }
            }, function ( err ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "-- add realm" );
                SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
            } );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.COMMON.ACTION.editInConfigFile                      = function ( timeout, config_file_path, parameter, value ) {
        var _command      = "grep " + parameter + " " + config_file_path;
        // First we verify if the parameter is already in the file
        var _grep_success = function ( _status, data ) {
            // The parameter is in the file, so we force its value to 1
            if ( data.rc === 0 ) {
                SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.replaceInFile( timeout, parameter + ".*", parameter + " " + value, config_file_path );
            }
            // The parameter is not in the file, so we add it
            else {
                _command          = "echo " + parameter + " " + value + " >> " + config_file_path;
                var _echo_success = function ( _status, data ) {
                };
                SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _echo_success, _error );
            }
        };
        var _error        = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _grep_success, _error );
        return 1000;
    };
    self.COMMON.ACTION.stopAll                               = function ( timeout ) {
        var _to_return = 15000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.stopAll' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, "service shinken" + " stop", function ( _status, data ) {
            }, function ( err ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "-- executePostCommand service shinken" + " stop" );
                SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
            } );
        }, timeout );
        return _to_return;
    };
    self.COMMON.ACTION.stop                                  = function ( timeout, daemon_name ) {
        var _to_return = 6000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, daemon_name.toUpperCase() + '.ACTION.stop' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, "service shinken-" + daemon_name + " stop", function ( _status, data ) {
            }, function ( err ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "-- executePostCommand service shinken-" + daemon_name + " stop" );
                SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
            } );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.COMMON.ACTION.restartAll                            = function ( timeout, must_reload ) {
        var _to_return = 20000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.restartAll' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, "service shinken" + " -d restart", function () {
                if ( must_reload ) {
                    SHINKEN.HIGHWAY.refreshCurrentPage();
                }
            }, function ( err ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "-- executePostCommand service shinken" + " -d restart" );
                SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
            } );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.COMMON.ACTION.restart                               = function ( timeout, daemon_name, must_reload ) {
        var _to_return = 10000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, daemon_name.toUpperCase() + '.ACTION.restart' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, "service shinken-" + daemon_name + " -d restart", function () {
                if ( must_reload ) {
                    SHINKEN.HIGHWAY.refreshCurrentPage();
                }
            }, function ( err ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "-- executePostCommand service shinken-" + daemon_name + " -d restart" );
                SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
            } );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.COMMON.TEST.hasRestart                              = function ( timeout, daemon_name ) {
        var _command = 'date +"%s"';
        var _success = function ( _status, data ) {
            if ( data.rc === 0 ) {
                var machine_time = parseInt( data.stdout.replace( /[\r\n]/gm, '' ) );
                var _file        = "/var/log/shinken/" + daemon_name + "*.log";
                var _command     = 'grep "Daemon start time=" ' + _file + " | awk -F \"[=]+\" '{print $2}'";
                var _success     = function ( _status, data ) {
                    if ( data.rc === 0 ) {
                        var restart_time = parseInt( data.stdout.trim().split( "\n" ).slice( -1 )[ 0 ] );
                        if ( machine_time === null || restart_time === null ) {
                            SHINKEN.TOOLS.TEST_AUTO.addError( "Cannot get machine or restart time" );
                            return;
                        }
                        var runtime        = machine_time - restart_time;
                        var accepted_delta = 3 * 60;
                        if ( runtime > accepted_delta ) {
                            SHINKEN.TOOLS.TEST_AUTO.addError( "The runtime is " + runtime + "s which is more than " + accepted_delta );
                        }
                    }
                };
                var _error       = function ( err ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( err );
                    SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
                };
                SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, _command, _success, _error );
            }
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, _command, _success, _error );
        }, timeout );
        return 1000;
    };
    self.COMMON.TEST.isLoggedOnAllDaemon                     = function ( timeout, to_grep, only_last_hour ) {
        return self.SCHEDULER.TEST.isLogged( timeout, to_grep, only_last_hour ) +
               self.ARBITER.TEST.isLogged( timeout, to_grep, only_last_hour ) +
               self.SYNCHRONIZER.TEST.isLogged( timeout, to_grep, only_last_hour );
    };
    self.COMMON.TEST.isNotLoggedOnAllDaemon                  = function ( timeout, to_grep, only_last_hour ) {
        return self.SCHEDULER.TEST.isNotLogged( timeout, to_grep, only_last_hour ) +
               self.ARBITER.TEST.isNotLogged( timeout, to_grep, only_last_hour ) +
               self.SYNCHRONIZER.TEST.isNotLogged( timeout, to_grep, only_last_hour );
    };
    self.COMMON.TEST.isLogged                                = function ( timeout, daemon_name, to_grep, only_last_hour ) {
        var _error     = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        var doIsLogged = function ( timeout, daemon_name, to_grep ) {
            var _file    = "/var/log/shinken/" + daemon_name + "d*.log";
            var _command = 'egrep "' + to_grep + '" ' + _file;
            var _success = function ( _status, data ) {
                if ( data.rc === 1 ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "Grep did not found what we wanted. Returned [ " + data.stdout + " ]" );
                }
            };
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        };
        if ( only_last_hour ) {
            var _get_time_command = 'printf \'%(%Y-%m-%d %H:)T\\n\' -1';
            
            var _get_time_command_success = function ( _status, data ) {
                if ( data.rc === 1 ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "Could not get machine date. Returned [ " + data.stdout + " ]" );
                }
                else {
                    doIsLogged( timeout, daemon_name, data.stdout.trim() + ".*" + to_grep );
                }
            };
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _get_time_command, _get_time_command_success, _error );
        }
        else {
            doIsLogged( timeout, daemon_name, to_grep );
        }
        return 15000;
    };
    self.COMMON.TEST.isNotLogged                             = function ( timeout, daemon_name, to_grep, only_last_hour ) {
        var _error        = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        var doIsNotLogged = function ( timeout, daemon_name, to_grep ) {
            var _file    = "/var/log/shinken/" + daemon_name + "d*.log";
            var _command = 'egrep "' + to_grep + '" ' + _file;
            
            var _success = function ( _status, data ) {
                if ( data.rc === 0 ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "Grep returned [ " + data.stdout + " ]" );
                }
            };
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        };
        if ( only_last_hour ) {
            var _get_time_command = 'printf \'%(%Y-%m-%d %H:)T\\n\' -1';
            
            var _get_time_command_success = function ( _status, data ) {
                if ( data.rc === 1 ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "Could not get machine date. Returned [ " + data.stdout + " ]" );
                }
                else {
                    doIsNotLogged( timeout, daemon_name, data.stdout.trim() + ".*" + to_grep );
                }
            };
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _get_time_command, _get_time_command_success, _error );
        }
        else {
            doIsNotLogged( timeout, daemon_name, to_grep );
        }
        return 15000;
    };
    //********************************************  ARBITER   **************************************************//
    self.ARBITER.ACTION.restart                              = function ( timeout, must_reload ) {
        return self.COMMON.ACTION.restart( timeout, "arbiter", must_reload );
    };
    self.ARBITER.ACTION.stop                                 = function ( timeout ) {
        return self.COMMON.ACTION.stop( timeout, "arbiter" );
    };
    self.ARBITER.TEST.hasRestart                             = function ( timeout ) {
        return self.COMMON.TEST.hasRestart( timeout, "arbiter" );
    };
    self.ARBITER.TEST.isLogged                               = function ( timeout, to_grep, only_last_hour ) {
        return self.COMMON.TEST.isLogged( timeout, "arbiter", to_grep, only_last_hour );
    };
    self.ARBITER.TEST.isNotLogged                            = function ( timeout, to_grep, only_last_hour ) {
        return self.COMMON.TEST.isNotLogged( timeout, "arbiter", to_grep, only_last_hour );
    };
    //********************************************  SYNCHRONIZER   **************************************************//
    self.SYNCHRONIZER.ACTION.enableEncryption                = function ( timeout ) {
        var _command = "shinken-protected-fields-encryption-enable -y";
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 10000;
    };
    self.SYNCHRONIZER.ACTION.removeFieldInProtectedList = function ( timeout, field_to_remove ) {
      var _command = "expect -c 'spawn shinken-protected-fields-data-manage -r " + field_to_remove + " ; expect \"(Y/n)\" ; send -- \"Y\\r\"'" + field_to_remove;
      var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 10000;
    };
    self.SYNCHRONIZER.ACTION.restart                         = function ( timeout, must_reload ) {
        return self.COMMON.ACTION.restart( timeout, "synchronizer", must_reload ) + 5000;
    };
    self.SYNCHRONIZER.ACTION.putSourceInProduction           = function ( timeout, source ) {
        var _command      = "grep api_trusted_source_enabled= /etc/shinken-user/configuration/daemons/synchronizers/synchronizer_cfg_overload.cfg";
        var _curl_success = function ( _status, data ) {
            if ( data.rc !== 0 ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Request failed [ " + data.stdout + " ]" );
            }
        };
        // First we verify that api_trusted_source_enabled parameter is already in the file
        var _grep_success = function ( _status, data ) {
            // The parameter is in the file, so we force its value to 1
            if ( data.rc === 0 ) {
                timeout += SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.replaceInFile( timeout, "api_trusted_source_enabled=0", "api_trusted_source_enabled=1", "/etc/shinken-user/configuration/daemons/synchronizers/synchronizer_cfg_overload.cfg" );
                timeout += self.SYNCHRONIZER.ACTION.restart( timeout );
                _command = "curl 'http://localhost:7765/trusted-source/v1/put-in-production?login=test_auto_user_executor&password=dGVzdF9hdXRvX3VzZXJfZXhlY3V0b3I=&filter=sources:" + source + "&item_type=hosts'";
                SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _curl_success, _error );
            }
            // The parameter is not in the file, so we add it
            else {
                _command          = "echo api_trusted_source_enabled=1 >> /etc/shinken-user/configuration/daemons/synchronizers/synchronizer_cfg_overload.cfg";
                var _echo_success = function ( _status, data ) {
                    timeout += self.SYNCHRONIZER.ACTION.restart( timeout );
                    _command = "curl 'http://localhost:7765/trusted-source/v1/put-in-production?login=test_auto_user_executor&password=dGVzdF9hdXRvX3VzZXJfZXhlY3V0b3I=&filter=sources:" + source + "&item_type=hosts'";
                    SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _curl_success, _error );
                };
                SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _echo_success, _error );
            }
        };
        var _error        = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _grep_success, _error );
        return 30000;
    };
    self.SYNCHRONIZER.ACTION.changeAddressDuplicateBehaviour = function ( timeout, new_behaviour ) {
        if ( __version_shinken === "V02.07.06" ){
            return 0;
        }
        var _to_return = 4000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'SYNCHRONIZER.ACTION.changeAddressDuplicateBehaviour', new_behaviour );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _url = '/internal/private_shinken_test/change_duplicate_address_behaviour?password=private_shinken_test&new_behaviour=' + new_behaviour;
            $.ajax( {
                type   : "get",
                url    : _url,
                success: function ( response ) {
                    SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
                },
                error  : function ( response ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "statusText=" + response.statusText );
                    if ( response.status === 403 ) {
                        SHINKEN.TOOLS.TEST_AUTO.addError( "-- Synchronizer not in debug mode -- rs-synchronizer-debug" );
                        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, "service shinken-synchronizer -d restart", function () {
                            SHINKEN.HIGHWAY.refreshCurrentPage();
                        }, function ( err ) {
                            SHINKEN.TOOLS.TEST_AUTO.addError( "-- executePostCommand service shinken-synchronizer -d restart" );
                            console.warn( "GSOU", "[ - ]", err );
                        } );
                    }
                    SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK", _to_return );
                }
            } );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.SYNCHRONIZER.TEST.isLogged                          = function ( timeout, to_grep, only_last_hour ) {
        return self.COMMON.TEST.isLogged( timeout, "synchronizer", to_grep, only_last_hour );
    };
    self.SYNCHRONIZER.TEST.isNotLogged                       = function ( timeout, to_grep, only_last_hour ) {
        return self.COMMON.TEST.isNotLogged( timeout, "synchronizer", to_grep, only_last_hour );
    };
    //********************************************  SCHEDULER   **************************************************//
    self.SCHEDULER.ACTION.restart                            = function ( timeout, must_reload ) {
        return self.COMMON.ACTION.restart( timeout, "scheduler", must_reload );
    };
    self.SCHEDULER.TEST.isLogged                             = function ( timeout, to_grep, only_last_hour ) {
        return self.COMMON.TEST.isLogged( timeout, "scheduler", to_grep, only_last_hour );
    };
    self.SCHEDULER.TEST.isNotLogged                          = function ( timeout, to_grep, only_last_hour ) {
        return self.COMMON.TEST.isNotLogged( timeout, "scheduler", to_grep, only_last_hour );
    };
    //********************************************  BROKER   **************************************************//
    self.BROKER.ACTION.restart                               = function ( timeout, must_reload ) {
        return self.COMMON.ACTION.restart( timeout, "broker", must_reload );
    };
    self.BROKER.TEST.isLogged                                = function ( timeout, to_grep, only_last_hour ) {
        return self.COMMON.TEST.isLogged( timeout, "broker", to_grep, only_last_hour );
    };
    self.BROKER.TEST.isNotLogged                             = function ( timeout, to_grep, only_last_hour ) {
        return self.COMMON.TEST.isNotLogged( timeout, "broker", to_grep, only_last_hour );
    };
    return self;
})
( SHINKEN.TOOLS.TEST_AUTO_DAEMON || {} );

SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT_CONST = {
    LOG_STATUS: {
        HIDDEN : 0,
        SUCCESS: 1,
        ERROR  : 2,
        WARNING: 3
    }
};