SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE = (function ( self ) {
    self.ACTION = {};
    
    //********************************************  ACTION   **************************************************//
    self.ACTION.resetTime          = function ( timeout ) {
        var _command = 'service ntpd restart';
        
        var _success = function ( _status, data ) {
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.replaceInFile         = function ( timeout, original_text, new_text, file ) {
        var _command = "sed -i 's/" + original_text + "/" + new_text + "/g' " + file;
        
        var _success = function ( _status, data ) {
            if ( data.rc !== 0 ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Error while replacing [ " + data.stdout + " ]" );
            }
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 500;
    };
    self.ACTION.addMinutes         = function ( timeout, minutes ) {
        var _command = 'date $(date +%m%d%H%M%Y.%S -d \'' + minutes + ' minutes\')';
        
        var _success = function ( _status, data ) {
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.dropDatabase = function ( timeout, database ) {
        var _command = "mongo " + database + " --eval " + "'db.dropDatabase()'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.deleteManyMongo = function ( timeout, database, collection, query ) {
        var _command = "mongo " + database + " --eval " + "'db.getCollection(\"" + collection + "\").remove(" + JSON.stringify(query) + ")'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    },
    self.ACTION.upsertDocumentToMongo = function ( timeout, database, collection, document_id, document ) {
        var _key_to_find = {"_id": document_id};
        var _command = "mongo " + database + " --eval " + "'db.getCollection(\"" + collection + "\").update(" + JSON.stringify(_key_to_find) + ", " + JSON.stringify( document ) + ", upsert=true)'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.executePostCommand = function ( timeout, command, success, error ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.executePostCommand', command );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            SHINKEN.COMUNICATION.requestPost( "http://" + SHINKEN.HIGHWAY.getHostName() + ":5000/push_commands", JSON.stringify( { "commands": command } ), success, error );
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE || {} );
