SHINKEN.TOOLS.TEST_AUTO_UI_VISU_DASHBOARD = (function ( self ) {
    self.DOM           = {};
    self.TEST          = {};
    self.ACTION        = {};
    self.CONST         = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getIframe = function () {
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).window.onerror = function () {
            _has_script_error++;
        };
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document;
    };
    self.DOM.getWidget = function ( widget_id ) {
        return self.DOM.getIframe().querySelector( "#widget-" + widget_id );
    };
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.SlaWeekHasNoData  = function ( timeout, widget_id ) {
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.SlaWeekHasNoData' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var widget      = self.DOM.getWidget( widget_id );
            var sla_details = widget.querySelectorAll( ".td-sla-widget .graph-container-table .shinken-week-detail-td .week-detail-percent-container" );
            for ( var i = 0; i < sla_details.length; i++ ) {
                if ( !sla_details[ i ].querySelector( ".week-detail-percent-no-data" ) ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "There is data in the SLA" );
                }
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return 1000;
    };
    self.TEST.SlaWeekHasData    = function ( timeout, widget_id, day_nb ) {
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.SlaWeekHasData' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var widget      = self.DOM.getWidget( widget_id );
            var sla_details = widget.querySelectorAll( ".td-sla-widget .graph-container-table .shinken-week-detail-td .week-detail-percent-container" );
            if ( sla_details[ day_nb - 1 ].querySelector( ".week-detail-percent-no-data" ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "There is no data in the SLA on day " + day_nb );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return 1000;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.removeDowntimes = function ( timeout ) {
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.removeDowntimes' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var downtimes_bin = self.DOM.getIframe().querySelectorAll( ".hide-if-no-right-downtime .shinkon-trash-open" );
            console.log( "[TCLE]", "", "", downtimes_bin );
            for ( var i = 0; i < downtimes_bin.length; i++ ) {
                downtimes_bin[ i ].parentElement.click();
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return 1000;
    };
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_DASHBOARD || {} );

