//__lib__ lib_common
'use strict';

MANAGER.EventManager = {
    last_element_hovered: null,
    stop_propagation    : false,
    mouse_down_target   : null,
    mouse_on_target     : null,
    //********************************************  WINDOW MODAL      ******************************************//
    openIframeModal      : function ( url, id ) {
        MANAGER.__instance_window_modal_manager.setIframe( url, id );
    },
    closeModal           : function () {
        MANAGER.__instance_window_modal_manager.close();
    },
    closeNotify          : function ( notify_id ) {
        MANAGER.__instance_notify_manager.close( notify_id );
    },
    clickOnToggleCollapse: function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, "shinken-toggle-parent", 25 );
        if ( !_parent_dom_element ) {
            return;
        }
        _parent_dom_element.classList.toggle( "shinken-collapsed" );
    },
    //********************************************  HEADER      ******************************************//
    logout: function () {
        window.location = '/logout';
        sessionStorage.removeItem( "user_id" );
    },
    //********************************************  GENERAL      ******************************************//
    onFocus        : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onFocus();
    },
    onFocusOut     : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onFocusOut( event );
    },
    stopPropagation: function ( event ) {
        if ( event ) {
            event.stopPropagation();
        }
        else {
            this.stop_propagation = true;
            var self              = this;
            setTimeout( function () {
                self.stop_propagation = false;
            }, 50 );
        }
    },
    clickOnRadioBtn: function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnRadioBtn( event );
    },
    clickOnButton  : function ( event, event_name, param ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( !_controller ){
            console.warn("[EventManager - clickOnButton]", "Controller not found", event.target );
            return;
        }
        if ( !event_name ) {
            var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 50 );
            if ( !_parent_dom_element ) {
                console.warn("[EventManager - clickOnButton]", "not element with data set 'name' found", event.target );
                return;
            }
            event_name = _parent_dom_element.dataset.name;
        }
        _controller.clickOnButton( event, event_name, param );
    },
    focusOnAnchor  : function ( event, uuid ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.focusOnAnchor( uuid );
    },
    onKeyUp        : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onKeyUp( event );
    },
    onKeyDown      : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onKeyDown( event );
    },
    onPaste        : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onPaste( event );
    },
    //********************************************  DRAG & DROP ******************************************//
    onDragStart: function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onDragStart( element_name );
        }
    },
    onDragMove : function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onDragMove( element_name );
        }
    },
    onDragStop : function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onDragStop( element_name );
        }
    },
    //********************************************  RESIZE ******************************************//
    onResizeStart: function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onResizeStart( element_name );
        }
    },
    onResizeMove : function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onResizeMove( element_name );
        }
    },
    onResizeStop : function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onResizeStop( element_name );
        }
    },
    //********************************************  PROPERTIES DATA  ******************************************//
    onChangeOnInputKey           : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.askComputeKeyAfterChange( event.target );
    },
    clickOnAddNewLocalMacro      : function () {
        return App.Elements.DataTab.addNewData();
    },
    clickOnDeletePropertyBtn     : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var _name               = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( _name );
        _object.delete();
    },
    clickDataCollapseButtonGlobal: function () {
        App.Elements.DataTab.toggleCollapseButtonGlobal();
    },
    clickDataCollapseButton      : function ( dom_element ) {
        App.Elements.DataTab.toggleCollapseButton( dom_element );
    },
    //********************************************  NAVIGATION      ******************************************//
    goToDataView           : function ( data_name ) {
        MANAGER.EventManager.clickOnWindowNavigation( null, MANAGER.__instance_element_distributor.current_element.uuid, true, WINDOW.CONST.ELEMENT.DATAS );
        var _prop = MANAGER.__instance_property_distributor.getDataWithName( data_name );
        if ( _prop && _prop.group_data ) {
            MANAGER.EventManager.clickOnDataNavigation( _prop.group_data.uuid );
        }
    },
    clickOnDataNavigation  : function ( group_uuid ) {
        App.Elements.DataTab.clickOnDataNavigation( group_uuid );
    },
    clickOnWindowNavigation: function ( event, name, update_url, window_name ) {
        if ( !window_name ) {
            var _nav_tab = DOM.Service.findParentElementWithClass( event.target, WINDOW.CONST.CLASS.WINDOW_TAB, 10 );
            if ( !_nav_tab ) {
                return;
            }
            window_name = _nav_tab.dataset.name;
        }
        var _parent_window = MANAGER.__instance_window_distributor.findParentWindow( name );
        
        _parent_window.clickOnWindow( window_name );
        if ( update_url ) {
            SHINKEN.HIGHWAY.goToElementTab( window_name );
        }
        
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.computeSizes();
        }
    },
    //********************************************  PROPERTIES CHECK  ******************************************//
    clickOnCheckboxInput: function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnCheckboxInput( event );
    },
    //********************************************  PROPERTIES STRING_INPUT  ******************************************//
    onChangeOnInput: function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onChangeOnInput( event );
    },
    onResize       : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onResize( dom_element );
    },
    //********************************************  PROPERTIES RANGE_INPUT  ******************************************//
    onMoveRangeCursor: function ( parent_name, ask_after_action, event ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onMoveRangeCursor( null, event );
        if ( ask_after_action ) {
            MANAGER.ListenerEventManager.askAfterActionProperty( _object );
        }
    },
    //********************************************  PROPERTIES MULTI-SELECT  *****************************************//
    clickOnBtnPlus           : function ( parent_name, event ) {
        this.stopPropagation();
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnBtnPlus( event );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnSelector          : function ( event, parent_name, controller_name ) {
        event.stopPropagation();
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        _controller.clickOnSelector( event, parent_name );
    },
    clickOnAllItemsSelector  : function ( parent_name, limit ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnAllItemsSelector( limit );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnItemSelector      : function ( event, parent_name, element, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        _controller.clickOnItemSelector( event, parent_name, element );
    },
    clickOnDeleteItemSelector: function ( parent_name, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnDeleteItemSelector( key_name );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    //********************************************  PROPERTIES GLOBAL   **********************************************//
    clickOnBtnInheritance: function ( parent_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnBtnInheritance();
    },
    clickOnInput         : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnInput( event );
    },
    muteEvent            : function ( event ) {
        event.preventDefault();
        event.stopPropagation();
    },
    mutePropagation      : function ( event ) {
        event.stopPropagation();
    },
    //********************************************  SOURCES   ********************************************************//
    clickOnToggleViewSource        : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnToggleViewSource( event );
    },
    clickOnActivatedSource         : function ( event ) {
        if ( !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnActivatedSource]", "[not admin]", "refused" );
            return;
        }
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.toggleSourceEnable( event );
    },
    clickOnActivatedDiscoverySource: function ( source_name, discovery_id ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnActivatedDiscoverySource]", "[not admin]", "refused" );
            return;
        }
        var _source    = MANAGER.__instance_source_distributor.findSource( source_name );
        var _discovery = _source[ SOURCE.CONST.FIELD.IP_RANGES ].getRangeById( discovery_id );
        _discovery.toggleEnable();
    },
    clickOnForceSource             : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnForceSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.askForceImport();
    },
    clickOnCleanSource             : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnCleanSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.cleanImport();
    },
    clickOnLastExecutionSource     : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnLastExecutionSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.redirectToSourceLastExecution();
    },
    //********************************************  WORKFLOW     *****************************************************//
    clickOnWorkflowTab       : function ( name ) {
        var dom_element = document.querySelector( "#shinken-workflow-container" );
        DOM.Service.setDataSet( dom_element, 'selected', name );
        dom_element.classList.toggle( 'PATCH_IE' );
    },
    clickOpenNewWindow       : function ( event, link, id ) {
        var _path = "/elements/";
        _path += link + '/';
        _path += id;
        if ( event.ctrlKey ) {
            window.open( _path, '_blank' );
        }
        else {
            window.location = _path;
        }
    },
    clickOnLinkForWorkingArea: function ( event, id ) { //NE MARCHE QUE POUR LES HOSTS
        var _path = "/elements/working_area/hosts/" + id;
        if ( event.ctrlKey ) {
            window.open( _path, '_blank' );
        }
        else {
            window.location = _path;
        }
    },
    //********************************************  OTHERS     *****************************************************//
    keydown                     : function ( event ) {
        var _key_code = event.keyCode;
        switch ( _key_code ) {
            case SHINKEN.CONST.KEY_CODE.F1:
                if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
                    window.onhelp = function () {
                        return false;
                    };
                }
                event.preventDefault();
                event.stopPropagation();
                break;
        }
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.keydown( event, _key_code );
        }
    },
    mouseEnter                  : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.mouseEnter( event );
        }
    },
    mouseLeave                  : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.mouseLeave( event );
        }
    },
    mouseMove                   : function ( event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.mouseMove( event );
        }
    },
    mouseWheel                  : function ( event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.mouseWheel( event );
        }
    },
    mouseDown                   : function ( event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.mouseDown( event );
        }
    },
    onClick                     : function ( event ) {
        if ( this.stop_propagation ) {
            this.stop_propagation = false;
            return;
        }
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.onClick( event );
        }
    },
    onScroll                    : function ( event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.onScroll( event );
        }
    },
    clickOnForcedHelpButton     : function ( event, dom_element ) {
        event.preventDefault();
        event.stopPropagation();
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 20 );
        var name                = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( name );
        _object.clickOnForcedHelpButton();
    },
    clickOnForcedHelpButtonCheck: function ( event, dom_element ) {
        //BGL EN ATTENDANT QU'UN CHECK MANAGER SOIT FAIT...
        event.preventDefault();
        event.stopPropagation();
        MANAGER.HelpManager.setForced( 'help_title_try_checks', dom_element, true );
    },
    clickOnPaste                : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.clickOnPaste( event );
        }
    },
    //********************************************  OVERRIDE     *****************************************************//
    clickOnModeTab              : function ( element, do_blink_animation ) {
        var _parent = document.getElementById( 'id-shinken-window-checks-target' );
        DOM.Service.setDataSet( _parent, 'tabSelected', element.dataset.value );
        if ( do_blink_animation ) {
            DOM.Service.askAddClass( element, 'shinken-pulsate', 2000 );
        }
        if ( element.dataset.value !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE ) {
            var _elements = document.querySelectorAll( '.shinken-tab-check-col-tags' );
            for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
                _elements[ i ].classList.remove( "shinken-active" );
            }
            var _elements_tr = document.querySelectorAll( '.shinken-tr-check-override' );
            for ( var i = 0, _size = _elements_tr.length; i < _size; i++ ) {
                _elements_tr[ i ].classList.add( "shinken-hidden" );
            }
        }
        MANAGER.__instance_navigator_size.tab_data_exclude();
    },
    clickOnSetOverride          : function ( dom_uuid ) {
        var _element = document.getElementById( 'id-shinken-window-checks-target' );
        if ( _element.dataset.tabSelected !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE ) {
            this.clickOnModeTab( _element.querySelector( '.shinken-check-mode-menu-tab[data-value="' + OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE + '"]' ), true );
        }
        App.Elements.ChecksTab.getCheckOverrideData( dom_uuid );
        MANAGER.ListenerEventManager.afterAction( MANAGER.CONST.AFTER_ACTION.CLICK_ON_SERVICE_OVERRIDE );
    },
    clickOnSetExclude           : function ( dom_uuid, event, ignore_if_on_status_exclude ) {
        if ( event ) {
            event.stopPropagation();
        }
        var _element = document.getElementById( 'id-shinken-window-checks-target' );
        if ( _element.dataset.tabSelected !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE ) {
            this.clickOnModeTab( _element.querySelector( '.shinken-check-mode-menu-tab[data-value="' + OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE + '"]' ), true );
        }
        else if ( !ignore_if_on_status_exclude ) {
            var _check_in_host = App.Elements.ChecksTab.getCheckInHostElement( dom_uuid );
            _check_in_host.changeExcludeStatus();
        }
    },
    clickOnDeleteInvalidOverride: function ( type, name ) {
        MANAGER.__instance_override_unvalid.deleteOverride( type, name );
        App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
    },
    clickOnCleanCheckOverrides  : function ( event, check_uuid ) {
        event.stopPropagation();
        var _confirm = confirm( _( 'element.confirm_remove_override' ) );
        if ( _confirm ) {
            var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
            _check_in_page_host.cleanOverride();
            App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
        }
    },
    //********************************************  CHECKS     *****************************************************//
    clickOnFocusOnDuplicateCheck: function ( check_uuid ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckByID( check_uuid );
        _check_in_page_host.dom_element.scrollIntoView( false );
        DOM.Service.askAddClass( _check_in_page_host.dom_element.querySelector( '.shinken-tab-check-col-name' ), 'shinken-pulsate-focus', 3000 );
    },
    //********************************************  TRY CHECKS     *****************************************************//
    clickOnTryCheck     : function ( check_uuid, is_exec, is_on_poller ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
        _check_in_page_host.askTryCheck( is_exec, is_on_poller );
    },
    clickOnCleanTryCheck: function ( check_uuid ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
        _check_in_page_host.hide_eval_check();
    },
    //********************************************  OUTPUT RULES     *****************************************************//
    clickOnMultiLineObjectAdd: function ( parent_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnAddLine();
    },
    clickOnDeleteLine        : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var _name               = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( _name );
        _object.deleteLine( dom_element );
    },
    //********************************************  OUTPUT RULES     *****************************************************//
    clickOnHooksPopup: function ( event, element ) {
        event.stopImmediatePropagation();
        var target    = element;
        var parent    = target.parentNode;
        var is_active = target.classList.contains( 'active' );
        if ( is_active ) {
            target.classList.remove( 'active' );
            parent.classList.remove( "shinken-force-display-block" );
        }
        else {
            target.classList.add( 'active' );
            parent.classList.add( "shinken-force-display-block" );
        }
    },
    //********************************************  LIST     *****************************************************//
    clickOnCollapseButton: function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnCollapseButton( event );
    },
    //********************************************  MASS CHANGE     *****************************************************//
    simulateClickOnFilter: function ( event, header_name, value ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.simulateClickOnFilter( event, header_name, value );
    },
    //********************************************  SOURCE     *****************************************************//
    clickOnForceImportInSource: function ( source_name ) {
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.URL
                     + source_name
                     + COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                _sources.refresh();
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
    },
    //********************************************  BROADCAST     *****************************************************//
    shinkenBroadcast: function ( key, value_object, event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.shinkenBroadcast( key, value_object );
        }
    }
};