//__lib__ lib_common
'use strict';

SHINKEN.TOOLS.ClockComponent           = function ( dom_element_parent ) {
    this.dom_element = dom_element_parent.querySelector(".shinken-clock-refresh");
    this.init();
};
SHINKEN.TOOLS.ClockComponent.prototype = {
    
    //********************************************  INIT  *****************************************************//
    init: function () {
        this.color = '#5C5C5C';
    },
    
    //********************************************  GETTER SETTER  *****************************************************//
    setColor: function ( color ) {
        this.color = color;
    },
    
    //********************************************  HTML  *****************************************************//
    set_refreshing_content  : function () {
        DOM.Service.addClasses( this.dom_element, 'shinken-clock-refreshing' );
    },
    unset_refreshing_content: function () {
        DOM.Service.removeClasses( this.dom_element, 'shinken-clock-refreshing' );
    },
    updateHtml              : function (percent) {
        var values = this.computeContent(percent);
        DOM.Service.setStyles( this.dom_element, {
            'background': 'linear-gradient(' + values.deg + 'deg, #ffffff 50%,transparent 0) 0/' + values.enabled_first_linear_gradiant + '%, '
                          + 'linear-gradient(' + values.deg + 'deg, transparent 50%, ' + this.color + ' 0) 0/' + values.enabled_second_linear_gradiant + '%, '
                          + 'linear-gradient(to right, #ffffff 50% ,' + this.color + ' 0)'
            
        } );
    },
    
    //********************************************  COMPUTE  *****************************************************//
    computeContent: function (percent) {
        
        var _deg = ((18 / 5) * percent - 90);
        
        var _to_compute_first  = (50 - percent) * 100;
        var _to_compute_second = (percent - 50) * 100;
        
        var _enabled_first_linear_gradiant  = 0;
        var _enabled_second_linear_gradiant = 0;
        
        if ( _to_compute_first === 100 || _to_compute_first > 100 ) {
            _enabled_first_linear_gradiant = 100;
        }
        if ( _to_compute_second === 100 || _to_compute_second > 100 ) {
            _enabled_second_linear_gradiant = 100;
        }
        return { deg: _deg, enabled_first_linear_gradiant: _enabled_first_linear_gradiant, enabled_second_linear_gradiant: _enabled_second_linear_gradiant };
    },
    
    //********************************************  OTHERS  *****************************************************//
    //********************************************  EVENT REFRESH  *****************************************************//
    eventIsRunning   : function () {
        this.unset_refreshing_content();
        this.updateHtml();
    },
    eventIsRefreshing: function () {
        this.set_refreshing_content();
    },
    updateCountdown       : function (parent_object ) {
        this.updateHtml( parent_object.getPercent() );
    },
    eventIsStopping  : function () {
        this.set_refreshing_content();
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.ClockComponent, SHINKEN.TOOLS.InterfaceRefreshComponent );

