//__lib__ lib_common
'use strict';

SHINKEN_GRID.Grid           = function ( data ) {
    //cells
    //dom_element
    //dom_element_highlight_cell
    //number_of_tile
    this.init( data );
};
SHINKEN_GRID.Grid.prototype = {
    init: function ( data ) {
        this.uuid            = SHINKEN.TOOLS.STRING.buildUUID();
        this.tile_pixel_size = 0;
        this.updateData( data );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    onMouseMove : function ( event ) {
    },
    onMouseLeave: function ( event ) {
    },
    onScroll    : function ( event ) {
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getChildrenObject      : function () {
        return [this.cells, this[ SHINKEN_GRID.CONST.PARAM.GRID.DEFAULT_CONFIGURATION ]];
    },
    getChildrenObjectDict  : function () {
        var to_return                                                    = {};
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ]         = this.cells;
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.DEFAULT_CONFIGURATION ] = this[ SHINKEN_GRID.CONST.PARAM.GRID.DEFAULT_CONFIGURATION ];
        return to_return;
    },
    _getObjectToJson       : function () {
        var to_return                                                              = {};
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.ORDERING ]                        = this[ SHINKEN_GRID.CONST.PARAM.GRID.ORDERING ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ]                     = this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ]                     = this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ]     = this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ]     = this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] = this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.TYPE ]                            = this[ SHINKEN_GRID.CONST.PARAM.GRID.TYPE ];
        return to_return;
    },
    setDefaultConfiguration: function ( value ) {
        this[ SHINKEN_GRID.CONST.PARAM.GRID.DEFAULT_CONFIGURATION ] = new SHINKEN.OBJECT.DefaultConfiguration( value );
    },
    //********************************************  COMPUTE  *****************************************************//
    computeNewPosition: function ( uuid ) {
        this.cells.computeNewPosition( uuid );
    },
    computeMapping    : function ( mapping ) {
        if ( this.cells ) {
            this.cells.computeMapping( mapping );
        }
    },
    computeSizes      : function () {
        this.updateStyle();
        this.computeTileSize();
        this.cells.updateSize( this.tile_pixel_size );
        if ( this.cells_documentation ) {
            this.cells_documentation.updateSize( this.tile_pixel_size );
        }
        
    },
    computeTileSize   : function () {
        this.tile_pixel_size = DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.WIDTH ) / this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ];
    },
    //********************************************  SAVE  *****************************************************//
    
    
    //********************************************  HTML   **************************************************//
    initDomElementHtml: function ( dom_parent ) {
        this.dom_element = DOM.Service.createElement( "div", { id: "id-shinken-" + this.uuid, class: "shinken-grid" } );
    },
    computeHtml       : function ( dom_parent ) {
        this.initDomElementHtml();
        DOM.Service.addElementTo( this.dom_element, dom_parent );
        DOM.Service.setDataSet( this.dom_element, 'gridUuid', this.uuid );
        
        this.computeTileSize();
        if ( this.cells_documentation ) {
            this.cells_documentation.computeHtml( this, "shinken-grid-structure" );
        }
        this.cells.computeHtml( this );
        this.updateStyle();
    },
    getComputedStyle  : function () {
        var _to_return                       = {};
        _to_return[ DOM.CONST.STYLE.HEIGHT ] = 0;
        return _to_return;
    },
    updateStyle       : function ( force_hidden ) {
        DOM.Service.setStyles( this.dom_element, this.getComputedStyle() );
    },
    //********************************************  UPDATE DATA   **************************************************//
    updateData              : function ( data ) {
        if ( !data ) {
            return;
        }
        
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            if ( _currentKey !== SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ) {
                this.setData( _currentKey, data[ _currentKey ] );
            }
        }
        if ( data[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ] ) {
            this.setData( SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS, data[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ] );
        }
    },
    setData                 : function ( key, value ) {
        switch ( key ) {
            case SHINKEN_GRID.CONST.PARAM.GRID.SHINKEN_GRID_UUID:
            case SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X:
            case SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y:
            case SHINKEN_GRID.CONST.PARAM.GRID.TYPE:
            case SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN:
            case SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX:
            case SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT:
                this[ key ] = value;
                break;
            case SHINKEN_GRID.CONST.PARAM.GRID.DEFAULT_CONFIGURATION:
                this.setDefaultConfiguration( value );
                break;
            case SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS:
                this.initCellsGrid( value );
                break;
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES:
                this.setMessages( value );
                break;
            default:
                if ( !this.setDataOnInheritedObject( key, value ) ) {
                    console.warn( "[IGNORED DATA]", key, value );
                    this.setUnknownValue( key, value );
                }
                break;
        }
    },
    setDataOnInheritedObject: function ( key, value ) {
        return false;
    },
    initCellsGrid           : function ( data ) {
        this.cells                 = new SHINKEN_GRID.Cells( data );
        //var _data_to_documentation = [];
        //for ( var i = 0, _size_i = this.nb_tiles_in_height; i < _size_i; i++ ) {
        //    for ( var j = 0, _size_j = this.nb_tiles_in_width; j < _size_j; j++ ) {
        //        _data_to_documentation.push( { height: 1, width: 1, position_x: j, position_y: i, content: { type: WIDGET.CONST.WIDGET_TYPE.SHINKEN_GRID_STRUCTURE } } );
        //    }
        //}
        //this.cells_documentation = new SHINKEN_GRID.Cells( _data_to_documentation );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grid, SHINKEN.OBJECT.ShinkenObjectJson );