//priority 4
//__lib__ lib_common
var SHINKEN_TOOLTIP = (function ( self ) {
    "use strict";
    
    self.PLACEMENT                = {};
    self.PLACEMENT.LEFT           = 'left';
    self.PLACEMENT.RIGHT          = 'right';
    self.PLACEMENT.TOP            = 'top';
    self.PLACEMENT.TOP_LEFT       = 'top-left';
    self.PLACEMENT.TOP_RIGHT      = 'top-right';
    self.PLACEMENT.BOTTOM         = 'bottom';
    self.PLACEMENT.BOTTOM_LEFT    = 'bottom-left';
    self.PLACEMENT.BOTTOM_RIGHT   = 'bottom-right';
    self.TYPE                     = {};
    self.TYPE.ERROR               = 'shinken-error';
    self.TYPE.ERROR_BORDER        = 'shinken-error-border';
    self.TYPE.WARNING             = 'shinken-warning';
    self.TYPE.WARNING_BORDER      = 'shinken-warning-border';
    self.TYPE.BEWARE_BORDER       = 'shinken-beware-border';
    self.TYPE.NORMAL_DISCREET     = 'shinken-normal-discreet';
    self.TYPE.NORMAL_ON_BLACK     = 'shinken-normal-on-black';
    self.TYPE.DISPLAY_TEXT        = 'shinken-normal-text';
    self.CONDITION                = {};
    self.CONDITION.SHIFT          = 'shinken-shift';
    self.CONDITION.CTRL_SHIFT     = 'shinken-ctrl-shift';
    self.CONDITION.ELLIPSIS       = 'shinken-ellipsis';
    self.STYLE                    = {};
    self.STYLE.PADDING_HORIZONTAL = 8;
    self.STYLE.PADDING_VERTICAL   = 4;
    self.STYLE.MIN_WIDTH_TEXT     = 60;
    self.STYLE.HEIGHT_TEXT_LINE   = 20;
    self.STYLE.ARROW_SIZE         = 5;
    self.DEFAULT                  = {};
    self.DEFAULT.TIMER_POP        = 100;
    self.MAX_TRY_IN_SCREEN        = 10;
    
    self.CONDITION_TYPE = {
        HAS_CLASS    : "has_class",
        HAS_NOT_CLASS: "has_not_class"
    };
    
    
    self.CONDITION_TYPE = {
        HAS_CLASS    : "has_class",
        HAS_NOT_CLASS: "has_not_class"
    };
    
    
    var __container;
    var __text_container;
    var __type;
    var __condition;
    var __arrow;
    var __placement;
    var __placement_origin;
    var __try;
    var __try_container;
    var __innerText;
    var __innerHtml;
    var __width;
    var __height;
    var __timer_pop;
    var __parent_container;
    var __classes_added;
    var __timeout_pop;
    var __interval_pop_out;
    var __interval_auto_scroll;
    var __timeout_auto_scroll;
    var __pos_top;
    var __pos_left;
    
    //public
    self.showTooltipIf = function ( element, condition_type, condition_value ) {
        if ( !condition_value || !condition_type ) {
            return;
        }
        switch ( condition_type ) {
            case self.CONDITION_TYPE.HAS_CLASS:
                if ( !element.classList.contains( condition_value ) ) {
                    return false;
                }
                break;
            case  self.CONDITION_TYPE.HAS_NOT_CLASS :
                var _splitted = condition_value.split( ',' );
                for ( var i = 0, _size = _splitted.length; i < _size; i++ ) {
                    if ( element.classList.contains( _splitted[ i ] ) ) {
                        return false;
                    }
                }
                break;
            default:
                console.log( "Type not manage" );
                return false;
        }
        _showTooltip( element );
    };
    
    self.showTooltip = function ( element ) {
        if ( !element ) {
            return;
        }
        if ( !__container ) {
            initDomElement();
        }
        if ( !__container ) {
            return;
        }
        var _condition_type = element.getAttribute( "shi-tip-condition-type" );
        if ( _condition_type ) {
            return self.showTooltipIf( element, _condition_type, element.getAttribute( "shi-tip-condition-value" ) );
        }
        
        _showTooltip( element );
    };
    
    self.hideTooltip   = function () {
        if ( __container ) {
            setActive( false );
            clean();
        }
    };
    self.updateTooltip = function ( element ) {
        if ( !DOM.Service.isVisible( __container ) ) {
            self.showTooltip( element );
            return;
        }
        _showTooltip( element, true );
    };
    
    //private
    function _showTooltip ( element, skip_clean ) {
        __try           = 0;
        __try_container = 0;
        if ( !skip_clean ) {
            clean();
        }
        setTimerPop( element );
        setText( element );
        setHTML( element );
        setType( element );
        setCondition( element );
        setParentContainer( element );
        if ( __innerText || __innerHtml ) {
            setClass( element );
            getSize();
            setPlacement( element );
            setPosition( element, skip_clean );
            setArrow();
            launchIntervalPopOut( element );
            launchIntervalAutoScroll( element );
        }
    }
    
    function setPlacement ( element ) {
        cleanArrow();
        __placement        = element.getAttribute( 'shi-tip-placement' ) || self.PLACEMENT.TOP;
        __placement_origin = __placement;
    }
    
    function setActive ( _bool ) {
        if ( _bool ) {
            __container.classList.add( 'shinken-tooltip-active' );
        }
        else {
            __container.classList.remove( 'shinken-tooltip-active' );
        }
    }
    
    function setArrow () {
        __container.classList.add( __placement );
    }
    
    function cleanIntervalPopOut () {
        if ( __interval_pop_out ) {
            clearInterval( __interval_pop_out );
            __interval_pop_out = null;
        }
    }
    
    function cleanIntervalAutoScroll () {
        __text_container.scrollTop = -400;
        if ( __timeout_auto_scroll ) {
            clearTimeout( __timeout_auto_scroll );
            __timeout_auto_scroll = null;
        }
        if ( __interval_auto_scroll ) {
            clearInterval( __interval_auto_scroll );
            __interval_auto_scroll = null;
        }
    }
    
    function launchIntervalPopOut ( element ) {
        cleanIntervalPopOut();
        var _data_timer                = new Date().getTime();
        var _selector                  = "[data-shinken-tooltip='" + _data_timer + "']";
        element.dataset.shinkenTooltip = _data_timer;
        __interval_pop_out             = setInterval( function () {
            var _elements = document.querySelector( _selector );
            if ( !_elements ) {
                setActive( false );
                cleanIntervalPopOut();
            }
        }, 1000 );
    }
    
    function launchIntervalAutoScroll ( element ) {
        cleanIntervalAutoScroll();
        if ( __text_container.clientHeight < __text_container.scrollHeight ) {
            __timeout_auto_scroll = setTimeout( function () {
                __interval_auto_scroll = setInterval( function () {
                    __text_container.scrollTop = __text_container.scrollTop + 1;
                    if ( __text_container.scrollTop >= __text_container.scrollHeight - __text_container.clientHeight ) {
                        __timeout_auto_scroll = setTimeout( function () {
                            launchIntervalAutoScroll();
                        }, 2000 );
                    }
                }, 100 );
            }, 2000 );
            
        }
        
    }
    
    function cleanArrow () {
        __container.classList.remove( __placement );
    }
    
    function cleanRectWidth ( _rect ) {
        var _to_return = Math.min( _rect.width, 600 );
        if ( __classes_added ) {
            if ( __classes_added.indexOf( '300' ) !== -1 ) { //BGL  A REFAIRE PROPRE
                _to_return = Math.min( _to_return, 300 );
            }
        }
        return _to_return;
    }
    
    function setPosition ( element_to_bind, skip_clean ) {
        if ( !skip_clean ) {
            clean();
        }
        var _rect       = element_to_bind.getBoundingClientRect();
        var _width_rect = cleanRectWidth( _rect );
        if ( !_width_rect ) {
            return; //ELEMENT NOT DISPLAYED
        }
        computePosition(_rect, _width_rect);
        
        if ( isInScreen() ) {
            if ( __try > self.MAX_TRY_IN_SCREEN ){
                computePosition(_rect, _width_rect);
            }
            __timeout_pop = setTimeout( function () {
                __container.style.top  = __pos_top + 'px';
                __container.style.left = __pos_left + 'px';
            }, __timer_pop );
        }
        else {
            setPosition( element_to_bind, skip_clean );
        }
    }
    
    function computePosition (_rect, _width_rect) {
        switch ( __placement ) {
            case self.PLACEMENT.TOP:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left + _width_rect / 2 - __width / 2);
                break;
            case self.PLACEMENT.TOP_LEFT:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - __width + _width_rect + 2 * self.STYLE.ARROW_SIZE;
                break;
            case self.PLACEMENT.TOP_RIGHT:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - 2 * self.STYLE.ARROW_SIZE;
                break;
            case self.PLACEMENT.LEFT:
                __pos_top  = (_rect.top + _rect.height / 2 - __height / 2);
                __pos_left = (_rect.left - __width);
                break;
            case self.PLACEMENT.RIGHT:
                __pos_top  = (_rect.top + _rect.height / 2 - __height / 2);
                __pos_left = (_rect.left + _width_rect);
                break;
            case self.PLACEMENT.BOTTOM:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left + _width_rect / 2 - __width / 2);
                break;
            case self.PLACEMENT.BOTTOM_LEFT:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - __width + _width_rect + 2 * self.STYLE.ARROW_SIZE;
                break;
            case self.PLACEMENT.BOTTOM_RIGHT:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - 2 * self.STYLE.ARROW_SIZE;
                break;
        }
    }
    
    function isInScreen () {
        var _to_return       = true;
        var _bounding_parent = __parent_container ? __parent_container.getBoundingClientRect() : false;
        var _left_parent     = _bounding_parent ? _bounding_parent.left : -10;
        var _right_parent    = _bounding_parent ? _bounding_parent.right : window.innerWidth - 10;
        var _top_parent      = _bounding_parent ? _bounding_parent.top : -10;
        var _bottom_parent   = _bounding_parent ? _bounding_parent.bottom : window.innerHeight - 10;
        
        
        if ( __pos_left < _left_parent ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.TOP_RIGHT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.BOTTOM_RIGHT:
                    __placement = self.PLACEMENT.RIGHT;
                    break;
                case self.PLACEMENT.TOP_LEFT:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.BOTTOM_RIGHT;
                    break;
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( (__pos_left + __width) > _right_parent ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.TOP_LEFT;
                    break;
                case self.PLACEMENT.TOP_LEFT:
                case self.PLACEMENT.RIGHT:
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.LEFT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.BOTTOM_LEFT;
                    break;
                case self.PLACEMENT.BOTTOM_RIGHT:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( __pos_top < _top_parent ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.TOP_LEFT:
                    __placement = self.PLACEMENT.BOTTOM_LEFT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                case self.PLACEMENT.RIGHT:
                    __placement = self.PLACEMENT.BOTTOM_RIGHT;
                    break;
            }
        }
        else if ( (__pos_top + __height) > _bottom_parent ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.TOP_LEFT;
                    break;
                case self.PLACEMENT.BOTTOM_RIGHT:
                case self.PLACEMENT.RIGHT:
                    __placement = self.PLACEMENT.TOP_RIGHT;
                    break;
            }
        }
        __try++;
        if ( __try > self.MAX_TRY_IN_SCREEN ) { //CASE WHERE THE TOOLTIP HAS NO PLACE TO BE DISPLAYED
            __placement = __placement_origin;
            _to_return  = true;
        }
        return _to_return;
    }
    
    function createDomElement () {
        var _html             = '<table><tr><td></td><td><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-left"></div></td><td><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-middle"></div></td><td><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-right"></div></td><td></td></tr><tr><td><div class="shi-tip-arrow tooltip-arrow-left" id="tooltip-arrow-left-middle"></div></td><td colspan="3"><div class="shi-tip-text"></div></td><td><div class="shi-tip-arrow tooltip-arrow-right" id="tooltip-arrow-right-middle"></div></td></tr><tr><td></td><td><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-left"></div></td><td><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-middle"></div></td><td><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-right"></div></td><td></td></tr></table>';
        __container           = document.createElement( 'div' );
        __container.id        = 'shi-tip';
        __container.innerHTML = _html;
        document.body.appendChild( __container );
    }
    
    function initDomElement () {
        __container = document.getElementById( 'shi-tip' );
        if ( !__container ) {
            createDomElement();
        }
        
        if ( __container ) {
            __text_container = __container.querySelector( '.shi-tip-text' );
            __arrow          = __container.querySelector( '.shi-tip-arrow' );
        }
    }
    
    function setText ( element ) {
        __innerText = element.getAttribute( 'shi-tip-text' );
        if ( __innerText ) {
            __text_container.innerHTML = __innerText;
        }
    }
    
    function setHTML ( element ) {
        __innerHtml = element.getAttribute( 'shi-tip-html' );
        if ( __innerHtml ) {
            __text_container.innerHTML = replaceAll( __innerHtml, '___', '&' );
        }
    }
    
    function setType ( element ) {
        __type                   = element.getAttribute( 'shi-tip-type' ) || false;
        __container.dataset.type = __type;
    }
    
    function setCondition ( element ) {
        __condition = element.getAttribute( 'shi-tip-condition' ) || false;
        
        __container.dataset.condition = __condition;
    }
    
    function setTimerPop ( element ) {
        __timer_pop = element.getAttribute( 'shi-tip-timer-pop' ) || self.DEFAULT.TIMER_POP;
    }
    
    function setParentContainer ( element ) {
        var _selector_parent_container = element.getAttribute( 'shi-tip-parent-container' );
        if ( _selector_parent_container ) {
            __parent_container = findParentElementWithClass( element, _selector_parent_container, 50 );
        }
        else {
            __parent_container = false;
        }
    }
    
    function setClass ( element ) {
        __classes_added = element.getAttribute( 'shi-tip-class' );
        
        __container.className = __classes_added;
    }
    
    function getSize () {
        setActive( true );
        var _sizes = __container.getBoundingClientRect();
        __width    = _sizes.width;
        __height   = _sizes.height;
    }
    
    function clean () {
        __container.style.top  = '-5000px';
        __container.style.left = '-5000px';
        clearTimeout( __timeout_pop );
        cleanIntervalPopOut();
        cleanIntervalAutoScroll();
    }
    
    //TOOLS
    function replaceAll ( string, target, replacement ) {
        return string.split( target ).join( replacement || '' );
    }
    
    function findParentElementWithClass ( element, class_tag, deepLimit ) {
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( !element ) {
            return null;
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        deepLimit--;
        return findParentElementWithClass( element.parentElement, class_tag, deepLimit );
    }
    
    return self;
    
})( {} );