# !/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.
import pickle
from cStringIO import StringIO

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    pass


class DataHubUnpickler(pickle.Unpickler):
    PICKLE_SAFE = {
        u'copy_reg'   : set([u'_reconstructor']),
        u'__builtin__': set([u'object', u'set']),
        
        # PYTHON 3
        u'copyreg'    : set([u'_reconstructor']),
        u'builtins'   : set([u'object', u'set']),
    }
    
    
    def find_class(self, module, name):
        if module not in self.PICKLE_SAFE:
            if not (name.startswith(u'DataHub')):
                raise pickle.UnpicklingError(u'Unpickle [ %s.%s ] is forbidden' %
                                             (module, name))
        real_module = __import__(module, fromlist=[''])
        return getattr(real_module, name)
    
    
    @staticmethod
    def loads(pickle_string):
        return DataHubUnpickler(StringIO(pickle_string)).load()
