# !/usr/bin/python
# -*- coding: utf-8 -*-

import os

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.
import errno

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    pass

try:
    import pwd
    import grp
    from pwd import getpwnam
    from grp import getgrnam
    
    
    def get_cur_user():
        return pwd.getpwuid(os.getuid()).pw_name
    
    
    def get_cur_group():
        return grp.getgrgid(os.getgid()).gr_name
except ImportError as exp:  # Like in nt system or Android
    pwd = grp = None
    
    
    def get_cur_user():
        return u'shinken'
    
    
    def get_cur_group():
        return u'shinken'


def make_dirs_and_chown_shinken(directory, mode=0o777):
    # type: (unicode, int) -> None
    head, tail = os.path.split(directory)
    if not tail:
        head, tail = os.path.split(head)
    if head and tail and not os.path.exists(head):
        try:
            make_dirs_and_chown_shinken(head, mode)
        except OSError as e:
            # be happy if someone already created the path
            if e.errno != errno.EEXIST:
                raise
        if tail == os.curdir:
            return
    os.mkdir(directory, mode)
    if pwd and grp and os.getuid() == 0:
        os.chown(directory, pwd.getpwnam(u'shinken').pw_uid, grp.getgrnam(u'shinken').gr_gid)


def make_file_and_chown_shinken(file_path):
    # type: (unicode) -> None
    with open(file_path, u'w') as _file:
        _file.write('')
    if pwd and grp:
        os.chown(file_path, pwd.getpwnam(u'shinken').pw_uid, grp.getgrnam(u'shinken').gr_gid)
