#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.


import six

if six.PY3:
    # noinspection PyUnresolvedReferences
    from queue import Empty
    # noinspection PyUnresolvedReferences
    import pickle as cPickle
    from io import StringIO as cStringIO
    
    StringIO = cStringIO
    # noinspection PyUnresolvedReferences
    import configparser as ConfigParser
else:
    # noinspection PyUnresolvedReferences
    from Queue import Empty
    # noinspection PyUnresolvedReferences
    import cPickle
    from cStringIO import StringIO as cStringIO
    # noinspection PyUnresolvedReferences
    from StringIO import StringIO
    # noinspection PyUnresolvedReferences
    import ConfigParser


def bytes_to_unicode(s, strict=False):
    if isinstance(s, str) and not six.PY3:  # python3 already is unicode in str
        if strict:
            return s.decode('utf8')
        return s.decode('utf8', 'ignore')
    if six.PY3 and (isinstance(s, bytes) or isinstance(s, bytearray)):  # bytearray is bytes that can mutate
        if strict:
            return s.decode('utf8')
        return s.decode('utf8', 'ignore')
    return s


def unicode_to_bytes(s):
    if isinstance(s, str) and six.PY3:
        return s.encode('utf8', 'ignore')
    return s
