#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022
# This file is part of Shinken Enterprise, all rights reserved.

import cPickle
import multiprocessing
import time
from Queue import Empty

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Number, Optional


class ShinkenQueue(object):
    def __init__(self, in_father_name=None, in_child_name=None):
        self.queue = multiprocessing.Queue()
        # We do not want to lock for this queue, we don't care about it
        self.queue.cancel_join_thread()
        self.in_father_name = in_father_name
        self.in_child_name = in_child_name
    
    
    def close(self):
        self.queue.close()
        self.queue.join_thread()
    
    
    def send(self, message):
        try:
            self.queue.put(message)
        except IOError:
            # logger.warning('The windows queue seems to be close, will be detected in the next loop')
            raise IOError(11, u'queue do not seems to be available')
    
    
    # Has element?
    def poll(self):
        r = not self.queue.empty()
        return r
    
    
    @staticmethod
    def write_poll(timeout):
        # type: (Optional[Number]) -> bool
        if timeout:
            time.sleep(timeout)
        return True
    
    
    # Get message
    # WARNING: we did check the poll, but the python doc say maybe this will be void...
    def recv(self):
        try:
            raw_message = self.queue.get_nowait()
        except Empty:  # Fake object then
            raw_message = cPickle.dumps(None)
        return raw_message
