#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2021:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.

from shinken.misc.type_hint import TYPE_CHECKING
from shinken.modules.base_sub_module.base_sub_module import BaseSubModule

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, Optional, Any
    from shinken.misc.monitoring_item_manager.monitoring_item_manager import MonitoringItemManager
    from shinken.modules.base_module.broker_base_module import ContextClass
    from shinken.webui.bottlewebui import LocalRequest, LocalResponse


class BaseSubModuleLivedata(BaseSubModule):
    
    def __init__(self, module_configuration):
        super(BaseSubModuleLivedata, self).__init__(module_configuration)
        self.monitoring_item_manager = None  # type: Optional[MonitoringItemManager]
        self.token = None  # type: Optional[unicode]
        self.lock = None  # type: Optional[ContextClass]
        self.request = None  # type: Optional[LocalRequest]
        self.response = None  # type: Optional[LocalResponse]
        self.abort = None  # type: Optional[Any]
    
    
    def get_routes(self):
        # type: () -> Dict
        raise NotImplementedError()
    
    
    def set_token(self, token):
        # type: (unicode) -> None
        self.token = token
    
    
    def set_monitoring_item_manager(self, monitoring_item_manager):
        # type: (MonitoringItemManager) -> None
        self.monitoring_item_manager = monitoring_item_manager
    
    
    def set_lock(self, consumer_lock):
        # type: (ContextClass) -> None
        self.lock = consumer_lock
    
    
    def set_bottle_properties(self, request, response, abort):
        self.request = request
        self.response = response
        self.abort = abort
