#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#     Gabes Jean, naparuba@gmail.com
#     Gerhard Lausser, Gerhard.Lausser@consol.de
#     Gregory Starck, g.starck@gmail.com
#     Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GN/etU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.

from shinken.satellitelink import SatelliteLink, SatelliteLinks
from shinken.property import IntegerProp, StringProp


class SynchronizerLink(SatelliteLink):
    id = 0
    my_type = 'synchronizer'
    properties = SatelliteLink.properties.copy()
    properties.update({
        'synchronizer_name': StringProp(),
        'port'             : IntegerProp(default='7765'),
    })
    
    
    def get_name(self):
        return getattr(self, 'synchronizer_name', 'unknown')


class SynchronizerLinks(SatelliteLinks):
    """Please Add a Docstring to describe the class here"""
    
    name_property = "synchronizer_name"
    inner_class = SynchronizerLink
