#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2023:
# This file is part of Shinken Enterprise, all rights reserved.
#
#
# File auto-generated

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, Set


# Contains default pickleable objects validated by Shinken
_SAFE_PICKLEABLE_CLASSES_DATABASE = {
    '__builtin__': set(['bool', 'complex', 'dict', 'float', 'frozenset', 'int', 'list', 'long', 'object', 'set', 'slice', 'str', 'tuple', 'unicode', 'xrange']),  # noqa: Auto-generated
    'builtins': set(['bool', 'bytes', 'complex', 'dict', 'float', 'frozenset', 'int', 'list', 'object', 'range', 'set', 'slice', 'str', 'tuple']),  # noqa: Auto-generated
    'collections': set(['Counter', 'OrderedDict', 'defaultdict', 'deque']),  # noqa: Auto-generated
    'copy_reg': set(['_reconstructor']),  # noqa: Auto-generated
    'copyreg': set(['_reconstructor']),  # noqa: Auto-generated
    'ordereddict': set(['OrderedDict']),  # noqa: Auto-generated
    'shinken.toolbox.pickledb': set(['ShinkenUnpickler']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub': set(['DataHubConfig']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_backup.data_hub_backup': set(['DataHubBackup', 'DataHubsBackup']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver': set(['AbstractDataHubDriverConfig']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver_database': set(['AbstractDataHubDriverConfigDatabase']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver_file': set(['AbstractDataHubDriverConfigFile']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_cPickle': set(['DataHubDriverConfigPickle']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_data_hub_config_file': set(['DataHubDriverConfigDataHubConfigFile']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_json': set(['DataHubDriverConfigJson']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_mmap_file': set(['DataHubDriverConfigMmapFile']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_mongo': set(['DataHubDriverConfigMongo']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_meta_driver.data_hub_meta_driver_cleanup_directory': set(['DataHubMetaDriverConfigCleanupDirectory']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_meta_driver.data_hub_meta_driver_replication': set(['DataHubMetaDriverConfigReplication']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_meta_driver.data_hub_meta_driver_retention': set(['DataHubMetaDriverConfigRetention']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_utils.data_hub_unpickler': set(['DataHubUnpickler']),  # noqa: Auto-generated
}  # type: Dict[str, Set[str]]
