#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.
import sys


def split_and_strip_list(str_list, separator=u','):
    if isinstance(str_list, list):
        return str_list
    if str_list:
        return [i.strip() for i in str_list.split(separator) if i.strip()]
    else:
        return []


def safe_replace(txt, old, new, text_limit=sys.maxint, nb_to_batch=8):
    # type: (unicode, unicode, unicode, int, int) -> (unicode, bool)
    # use iterative replace for protect again memory explosion
    # return a bool that is True if the replace was complete
    cur_txt = txt
    nw_txt = cur_txt.replace(old, new, nb_to_batch)
    while cur_txt != nw_txt and len(nw_txt) < text_limit:
        cur_txt = nw_txt
        nw_txt = cur_txt.replace(old, new, nb_to_batch)
    
    return nw_txt, cur_txt == nw_txt
